"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _utilities = require("../utilities");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const FLOW_STRICT_MATCHER = /^\s*@(?:no)?flow\s*strict(?:-local)?\s*$/u;

const isStrictFlowFile = context => context.getAllComments().some(comment => FLOW_STRICT_MATCHER.test(comment.value));

const message = 'No suppression comments are allowed in "strict" Flow files. Either remove the error suppression, or lower the strictness of this module.';
const schema = [{
  additionalProperties: false,
  properties: {},
  type: 'object'
}];

_utilities.suppressionTypes.forEach(o => {
  schema[0].properties[o] = {
    type: 'boolean'
  };
});

const create = context => {
  const suppressionOptions = _lodash.default.get(context, 'options[0]', {});

  if (!isStrictFlowFile(context)) {
    // Skip this file - nothing to check here
    return {};
  }

  return {
    Program: () => {
      const comments = context.getSourceCode().getAllComments().filter(node => node.type === 'Block' || node.type === 'Line');

      for (const commentNode of comments) {
        const comment = commentNode.value.trimStart();

        const match = _utilities.suppressionTypes.some(prefix => {
          if (suppressionOptions[prefix] === false) return false;
          return comment.startsWith(prefix);
        });

        if (match) {
          context.report({
            message,
            node: commentNode
          });
        }
      }
    }
  };
};

var _default = {
  create,
  schema
};
exports.default = _default;
module.exports = exports.default;