# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-04-06 10:11
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="LessPassUser",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("password", models.CharField(max_length=128, verbose_name="password")),
                (
                    "last_login",
                    models.DateTimeField(
                        blank=True, null=True, verbose_name="last login"
                    ),
                ),
                (
                    "email",
                    models.EmailField(
                        max_length=255, unique=True, verbose_name="email address"
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("is_admin", models.BooleanField(default=False)),
            ],
            options={
                "verbose_name_plural": "Users",
            },
        ),
        migrations.CreateModel(
            name="Entry",
            fields=[
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="modified"),
                ),
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("login", models.CharField(default="", max_length=255)),
                ("site", models.CharField(default="", max_length=255)),
                ("title", models.CharField(blank=True, max_length=255, null=True)),
                ("username", models.CharField(blank=True, max_length=255, null=True)),
                ("email", models.EmailField(blank=True, max_length=254, null=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("url", models.URLField(blank=True, null=True)),
            ],
            options={
                "verbose_name_plural": "Entries",
            },
        ),
        migrations.CreateModel(
            name="PasswordInfo",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("counter", models.IntegerField(default=1)),
                ("settings", models.TextField()),
                ("length", models.IntegerField(default=12)),
            ],
            options={
                "verbose_name_plural": "Password info",
            },
        ),
        migrations.AddField(
            model_name="entry",
            name="password",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="api.PasswordInfo"
            ),
        ),
        migrations.AddField(
            model_name="entry",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="entries",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
    ]
