/*
 * GNU General Public License v3.0
 *
 * Copyright (c) 2021 Toh Jeen Gie Keith
 *
 *
 * This file is part of Ohms Now!.
 *
 * Ohms Now! is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Ohms Now! is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Ohms Now!.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.ktprograms.ohmsnow

/* Pair and Triple extension functions for comparing values */
operator fun <T: Comparable<T>> Pair<T, T>.compareTo(other: Pair<T, T>) =
        compareValuesBy(this, other, { it.first }, { it.second })
operator fun <T: Comparable<T>> Triple<T, T, T>.compareTo(other: Triple<T, T, T>) =
        compareValuesBy(this, other, { it.first }, { it.second }, { it.third })

val e6 = listOf(
        Pair(1, 0),
        Pair(1, 5),
        Pair(2, 2),
        Pair(3, 3),
        Pair(4, 7),
        Pair(6, 8)
)

val e12 = listOf(
        Pair(1, 0),
        Pair(1, 2),
        Pair(1, 5),
        Pair(1, 8),
        Pair(2, 2),
        Pair(2, 7),
        Pair(3, 3),
        Pair(3, 9),
        Pair(4, 7),
        Pair(5, 6),
        Pair(6, 8),
        Pair(8, 2)
)

val e24 = listOf(
        Pair(1, 0),
        Pair(1, 1),
        Pair(1, 2),
        Pair(1, 3),
        Pair(1, 5),
        Pair(1, 6),
        Pair(1, 8),
        Pair(2, 0),
        Pair(2, 2),
        Pair(2, 4),
        Pair(2, 7),
        Pair(3, 0),
        Pair(3, 3),
        Pair(3, 6),
        Pair(3, 9),
        Pair(4, 3),
        Pair(4, 7),
        Pair(5, 1),
        Pair(5, 6),
        Pair(6, 2),
        Pair(6, 8),
        Pair(7, 5),
        Pair(8, 2),
        Pair(9, 1)
)

val e48 = listOf(
        Triple(1, 0, 0),
        Triple(1, 0, 5),
        Triple(1, 1, 0),
        Triple(1, 1, 5),
        Triple(1, 2, 1),
        Triple(1, 2, 7),
        Triple(1, 3, 3),
        Triple(1, 4, 0),
        Triple(1, 4, 7),
        Triple(1, 5, 4),
        Triple(1, 6, 2),
        Triple(1, 6, 9),
        Triple(1, 7, 8),
        Triple(1, 8, 7),
        Triple(1, 9, 6),
        Triple(2, 0, 5),
        Triple(2, 1, 5),
        Triple(2, 2, 6),
        Triple(2, 3, 7),
        Triple(2, 4, 9),
        Triple(2, 6, 1),
        Triple(2, 7, 4),
        Triple(2, 8, 7),
        Triple(3, 0, 1),
        Triple(3, 1, 6),
        Triple(3, 3, 2),
        Triple(3, 4, 8),
        Triple(3, 6, 5),
        Triple(3, 8, 3),
        Triple(4, 0, 2),
        Triple(4, 2, 2),
        Triple(4, 4, 2),
        Triple(4, 6, 4),
        Triple(4, 8, 7),
        Triple(5, 1, 1),
        Triple(5, 3, 6),
        Triple(5, 6, 2),
        Triple(5, 9, 0),
        Triple(6, 1, 9),
        Triple(6, 4, 9),
        Triple(6, 8, 1),
        Triple(7, 1, 5),
        Triple(7, 5, 0),
        Triple(7, 8, 7),
        Triple(8, 2, 5),
        Triple(8, 6, 6),
        Triple(9, 0, 9),
        Triple(9, 5, 3)
)

val e96 = listOf(
        Triple(1, 0, 0),
        Triple(1, 0, 2),
        Triple(1, 0, 5),
        Triple(1, 0, 7),
        Triple(1, 1, 0),
        Triple(1, 1, 3),
        Triple(1, 1, 5),
        Triple(1, 1, 8),
        Triple(1, 2, 1),
        Triple(1, 2, 4),
        Triple(1, 2, 7),
        Triple(1, 3, 0),
        Triple(1, 3, 3),
        Triple(1, 3, 7),
        Triple(1, 4, 0),
        Triple(1, 4, 3),
        Triple(1, 4, 7),
        Triple(1, 5, 0),
        Triple(1, 5, 4),
        Triple(1, 5, 8),
        Triple(1, 6, 2),
        Triple(1, 6, 5),
        Triple(1, 6, 9),
        Triple(1, 7, 4),
        Triple(1, 7, 8),
        Triple(1, 8, 2),
        Triple(1, 8, 7),
        Triple(1, 9, 1),
        Triple(1, 9, 6),
        Triple(2, 0, 0),
        Triple(2, 0, 5),
        Triple(2, 1, 0),
        Triple(2, 1, 5),
        Triple(2, 2, 1),
        Triple(2, 2, 6),
        Triple(2, 3, 2),
        Triple(2, 3, 7),
        Triple(2, 4, 3),
        Triple(2, 4, 9),
        Triple(2, 5, 5),
        Triple(2, 6, 1),
        Triple(2, 6, 7),
        Triple(2, 7, 4),
        Triple(2, 8, 0),
        Triple(2, 8, 7),
        Triple(2, 9, 4),
        Triple(3, 0, 1),
        Triple(3, 0, 9),
        Triple(3, 1, 6),
        Triple(3, 2, 4),
        Triple(3, 3, 2),
        Triple(3, 4, 0),
        Triple(3, 4, 8),
        Triple(3, 5, 7),
        Triple(3, 6, 5),
        Triple(3, 7, 4),
        Triple(3, 8, 3),
        Triple(3, 9, 2),
        Triple(4, 0, 2),
        Triple(4, 1, 2),
        Triple(4, 2, 2),
        Triple(4, 3, 2),
        Triple(4, 4, 2),
        Triple(4, 5, 3),
        Triple(4, 6, 4),
        Triple(4, 7, 5),
        Triple(4, 8, 7),
        Triple(4, 9, 9),
        Triple(5, 1, 1),
        Triple(5, 2, 3),
        Triple(5, 3, 6),
        Triple(5, 4, 9),
        Triple(5, 6, 2),
        Triple(5, 7, 6),
        Triple(5, 9, 0),
        Triple(6, 0, 4),
        Triple(6, 1, 9),
        Triple(6, 3, 4),
        Triple(6, 4, 9),
        Triple(6, 6, 5),
        Triple(6, 8, 1),
        Triple(6, 9, 8),
        Triple(7, 1, 5),
        Triple(7, 3, 2),
        Triple(7, 5, 0),
        Triple(7, 6, 8),
        Triple(7, 8, 7),
        Triple(8, 0, 6),
        Triple(8, 2, 5),
        Triple(8, 4, 5),
        Triple(8, 6, 6),
        Triple(8, 8, 7),
        Triple(9, 0, 9),
        Triple(9, 3, 1),
        Triple(9, 5, 3),
        Triple(9, 7, 6)
)

val e192 = listOf(
        Triple(1, 0, 0),
        Triple(1, 0, 1),
        Triple(1, 0, 2),
        Triple(1, 0, 4),
        Triple(1, 0, 5),
        Triple(1, 0, 6),
        Triple(1, 0, 7),
        Triple(1, 0, 9),
        Triple(1, 1, 0),
        Triple(1, 1, 1),
        Triple(1, 1, 3),
        Triple(1, 1, 4),
        Triple(1, 1, 5),
        Triple(1, 1, 7),
        Triple(1, 1, 8),
        Triple(1, 2, 0),
        Triple(1, 2, 1),
        Triple(1, 2, 3),
        Triple(1, 2, 4),
        Triple(1, 2, 6),
        Triple(1, 2, 7),
        Triple(1, 2, 9),
        Triple(1, 3, 0),
        Triple(1, 3, 2),
        Triple(1, 3, 3),
        Triple(1, 3, 5),
        Triple(1, 3, 7),
        Triple(1, 3, 8),
        Triple(1, 4, 0),
        Triple(1, 4, 2),
        Triple(1, 4, 3),
        Triple(1, 4, 5),
        Triple(1, 4, 7),
        Triple(1, 4, 9),
        Triple(1, 5, 0),
        Triple(1, 5, 2),
        Triple(1, 5, 4),
        Triple(1, 5, 6),
        Triple(1, 5, 8),
        Triple(1, 6, 0),
        Triple(1, 6, 2),
        Triple(1, 6, 4),
        Triple(1, 6, 5),
        Triple(1, 6, 7),
        Triple(1, 6, 9),
        Triple(1, 7, 2),
        Triple(1, 7, 4),
        Triple(1, 7, 6),
        Triple(1, 7, 8),
        Triple(1, 8, 0),
        Triple(1, 8, 2),
        Triple(1, 8, 4),
        Triple(1, 8, 7),
        Triple(1, 8, 9),
        Triple(1, 9, 1),
        Triple(1, 9, 3),
        Triple(1, 9, 6),
        Triple(1, 9, 8),
        Triple(2, 0, 0),
        Triple(2, 0, 3),
        Triple(2, 0, 5),
        Triple(2, 0, 8),
        Triple(2, 1, 0),
        Triple(2, 1, 3),
        Triple(2, 1, 5),
        Triple(2, 1, 8),
        Triple(2, 2, 1),
        Triple(2, 2, 3),
        Triple(2, 2, 6),
        Triple(2, 2, 9),
        Triple(2, 3, 2),
        Triple(2, 3, 4),
        Triple(2, 3, 7),
        Triple(2, 4, 0),
        Triple(2, 4, 3),
        Triple(2, 4, 6),
        Triple(2, 4, 9),
        Triple(2, 5, 2),
        Triple(2, 5, 5),
        Triple(2, 5, 8),
        Triple(2, 6, 1),
        Triple(2, 6, 4),
        Triple(2, 6, 7),
        Triple(2, 7, 1),
        Triple(2, 7, 4),
        Triple(2, 7, 7),
        Triple(2, 8, 0),
        Triple(2, 8, 4),
        Triple(2, 8, 7),
        Triple(2, 9, 1),
        Triple(2, 9, 4),
        Triple(2, 9, 8),
        Triple(3, 0, 1),
        Triple(3, 0, 5),
        Triple(3, 0, 9),
        Triple(3, 1, 2),
        Triple(3, 1, 6),
        Triple(3, 2, 0),
        Triple(3, 2, 4),
        Triple(3, 2, 8),
        Triple(3, 3, 2),
        Triple(3, 3, 6),
        Triple(3, 4, 0),
        Triple(3, 4, 4),
        Triple(3, 4, 8),
        Triple(3, 5, 2),
        Triple(3, 5, 7),
        Triple(3, 6, 1),
        Triple(3, 6, 5),
        Triple(3, 7, 0),
        Triple(3, 7, 4),
        Triple(3, 7, 9),
        Triple(3, 8, 3),
        Triple(3, 8, 8),
        Triple(3, 9, 2),
        Triple(3, 9, 7),
        Triple(4, 0, 2),
        Triple(4, 0, 7),
        Triple(4, 1, 2),
        Triple(4, 1, 7),
        Triple(4, 2, 2),
        Triple(4, 2, 7),
        Triple(4, 3, 2),
        Triple(4, 3, 7),
        Triple(4, 4, 2),
        Triple(4, 4, 8),
        Triple(4, 5, 3),
        Triple(4, 5, 9),
        Triple(4, 6, 4),
        Triple(4, 7, 0),
        Triple(4, 7, 5),
        Triple(4, 8, 1),
        Triple(4, 8, 7),
        Triple(4, 9, 3),
        Triple(4, 9, 9),
        Triple(5, 0, 5),
        Triple(5, 1, 1),
        Triple(5, 1, 7),
        Triple(5, 2, 3),
        Triple(5, 3, 0),
        Triple(5, 3, 6),
        Triple(5, 4, 2),
        Triple(5, 4, 9),
        Triple(5, 5, 6),
        Triple(5, 6, 2),
        Triple(5, 6, 9),
        Triple(5, 7, 6),
        Triple(5, 8, 3),
        Triple(5, 9, 0),
        Triple(5, 9, 7),
        Triple(6, 0, 4),
        Triple(6, 1, 2),
        Triple(6, 1, 9),
        Triple(6, 2, 6),
        Triple(6, 3, 4),
        Triple(6, 4, 2),
        Triple(6, 4, 9),
        Triple(6, 5, 7),
        Triple(6, 6, 5),
        Triple(6, 7, 3),
        Triple(6, 8, 1),
        Triple(6, 9, 0),
        Triple(6, 9, 8),
        Triple(7, 0, 6),
        Triple(7, 1, 5),
        Triple(7, 2, 3),
        Triple(7, 3, 2),
        Triple(7, 4, 1),
        Triple(7, 5, 0),
        Triple(7, 5, 9),
        Triple(7, 6, 8),
        Triple(7, 7, 7),
        Triple(7, 8, 7),
        Triple(7, 9, 6),
        Triple(8, 0, 6),
        Triple(8, 1, 6),
        Triple(8, 2, 5),
        Triple(8, 3, 5),
        Triple(8, 4, 5),
        Triple(8, 5, 6),
        Triple(8, 6, 6),
        Triple(8, 7, 6),
        Triple(8, 8, 7),
        Triple(8, 9, 8),
        Triple(9, 0, 9),
        Triple(9, 2, 0),
        Triple(9, 3, 1),
        Triple(9, 4, 2),
        Triple(9, 5, 3),
        Triple(9, 6, 5),
        Triple(9, 7, 6),
        Triple(9, 8, 8)
)