# 🔣 Symbol Reference Guide
*v1.0 | Created: 2025-04-15 | Updated: 2025-04-15*

## 📁 File Symbols
- 📂 = /memory-bank/
- 📦 = /memory-bank/backups/
- 📜 = /.specstory/history/

## 🔠 Mode Symbols
- Ω₁ = 🔍R = Research
- Ω₂ = 💡I = Innovate
- Ω₃ = 📝P = Plan
- Ω₄ = ⚙️E = Execute
- Ω₅ = 🔎RV = Review
- 💾U = Update (Memory Update)
- 📖L = Load (Memory Context Load)
- 🔄O = Organize (Information Organization)
- 🔄R = Reset (Project Reset)
- 🚀S = Start (Framework Initialization)

## 📈 Phase Symbols
- Π₁ = 🌱UNINITIATED
- Π₂ = 🚧INITIALIZING
- Π₃ = 🏗️DEVELOPMENT
- Π₄ = 🔧MAINTENANCE

## 🧠 Memory File Symbols
- σ₁ = 📋 Project Brief
- σ₂ = 🏛️ System Patterns
- σ₃ = 💻 Technical Context
- σ₄ = 🔮 Active Context
- σ₅ = 📊 Progress Tracker
- σ₆ = 🎯 Product Context
- σ₇ = 💬 Conversation History

## ⚙️ Command Shortcuts
- /r = Research mode
- /i = Innovate mode
- /p = Plan mode
- /e = Execute mode
- /rev = Review mode
- /u = Update memory files
- /l = Load memory context
- /o = Organize information
- /rs = Reset project direction
- /start = Initialize framework

## 📑 Decision Status Symbols
- 🔄 = Proposed
- ✅ = Accepted
- ⚙️ = Implemented
- ↪️ = Superseded
- ❌ = Abandoned

## 🏷️ Information Importance
- 🔴 = Critical (crucial for project success)
- 🟠 = Important (significant impact)
- 🟢 = Contextual (background information)

## 📂 Memory File Hierarchy
- σ₁ (Project Brief) forms the foundation
- σ₆ (Product Context), σ₂ (System Patterns), σ₃ (Technical Context) build on σ₁
- σ₄ (Active Context) integrates σ₂, σ₃, and σ₆
- σ₅ (Progress Tracker) builds on σ₄
- σ₇ (Conversation History) spans across all layers 