# 常見問題

收集使用者最常遇到的問題和解決方案。

## 安裝相關

### Q: 模組安裝後不工作？
**A**: 檢查以下項目：
1. 確認 Xposed 框架正常執行
2. 在框架管理器中勾選 NoWakeLock 模組
3. 重啟裝置後檢查模組狀態
4. 確認作用域包含 `android` 系統框架

### Q: 支援哪些 Xposed 框架？
**A**: 支援的框架：
- **LSPosed** - 推薦，相容性最好
- **EdXposed** - 部分裝置支援
- **TaiChi** - 不建議，可能存在相容問題

### Q: 模組檢查顯示紅色❌？
**A**: 根據具體項目處理：
- **框架未啟用** → 檢查 Xposed 安裝
- **模組未載入** → 確認模組已勾選並重啟
- **Hook失敗** → 可能是系統版本不相容

## 功能使用

### Q: 設定規則後沒有效果？
**A**: 可能的原因：
1. **規則未生效** - 檢查規則是否啟用
2. **應用程式重啟** - 部分規則需要應用程式重新啟動
3. **系統快取** - 等待幾分鐘讓系統應用新規則
4. **權限問題** - 確認 NoWakeLock 有必要權限

### Q: 某個應用程式無法接收推送？
**A**: 解決步驟：
1. 檢視該應用程式的 WakeLock 清單
2. 找到推送相關的 WakeLock（通常包含 Push、GCM、FCM）
3. 將這些 WakeLock 改為「允許」模式
4. 重啟應用程式測試推送功能

### Q: 應用程式變得很卡或功能異常？
**A**: 立即處理：
1. 暫時停用該應用程式的所有規則
2. 逐個啟用規則，找出問題規則
3. 調整問題規則的參數或改為限制模式
4. 避免攔截系統關鍵服務

### Q: 如何判斷優化是否有效？
**A**: 觀察指標：
- **短期（24小時）**：檢視攔截統計，應用程式功能正常
- **中期（一週）**：電池續航明顯改善
- **長期**：系統整體流暢度提升

## 相容性問題

### Q: Android 版本相容性？
**A**: 支援情況：
- **Android 7.0-16** - AOSP 完全支援

### Q: 特定品牌裝置問題？
**A**: 已知問題：
- **MIUI** - 需要關閉 MIUI 優化，允許背景執行
- **ColorOS** - 可能需要在權限管理中允許自啟動
- **EMUI** - 建議在受保護應用程式中新增 NoWakeLock
- **OneUI** - ⚠️ **目前尚不支援** - 由於 OneUI 更改了 Android 原始碼，Hook 位置經過多種方法嘗試，始終無法生效

### Q: 系統更新後失效？
**A**: 處理步驟：
1. 檢查 Xposed 框架是否仍然工作
2. 確認 NoWakeLock 模組仍在啟用狀態
3. 必要時重新安裝模組
4. 重新設定作用域設定

## 效能問題

### Q: NoWakeLock 本身耗電？
**A**: 正常情況下 NoWakeLock 耗電極少：
- **CPU 使用** < 1%
- **記憶體佔用** < 50MB
- **背景活動** 最小化

如果發現異常耗電，請檢查設定或聯絡支援。

### Q: 裝置變慢或卡頓？
**A**: 可能原因：
1. **規則過多** - 減少不必要的規則
2. **複雜正規表示式** - 簡化正規表示式
3. **頻繁攔截** - 調整攔截策略
4. **記憶體不足** - 重啟裝置釋放記憶體

### Q: 應用程式啟動變慢？
**A**: 檢查是否：
1. 攔截了應用程式啟動必需的 Service
2. 過度限制了初始化相關的 WakeLock
3. 規則影響了應用程式的啟動流程

## 資料問題

### Q: 統計資料不準確？
**A**: 可能情況：
1. **資料延遲** - 統計每5分鐘更新一次
2. **裝置重啟** - 部分即時資料重啟後重設
3. **時區問題** - 檢查裝置時區設定
4. **儲存問題** - 清理資料庫快取

### Q: 歷史資料遺失？
**A**: 資料保留策略：
- **即時資料** - 裝置重啟後清除
- **統計資料** - 保留30天
- **設定資料** - 永久儲存（除非手動清除）

### Q: 匯出的設定無法匯入？
**A**: 檢查項目：
1. 檔案格式是否正確（JSON）
2. 版本是否相容
3. 檔案是否損壞
4. 權限是否充足

## 多使用者問題

### Q: 多使用者環境下如何使用？
**A**: 注意事項：
1. 每個使用者需要單獨設定
2. 系統應用程式在所有使用者間共享設定
3. 切換使用者後設定互不影響
4. 某些功能需要主使用者權限

### Q: 工作資料下無法使用？
**A**: 工作資料限制：
1. 需要在工作資料中單獨安裝 Xposed 框架
2. 部分企業策略可能禁止 Xposed 模組
3. 聯絡管理員確認相關政策

## 安全問題

### Q: NoWakeLock 是否安全？
**A**: 安全措施：
- **開源程式碼** - 所有程式碼公開可審查
- **無網路權限** - 不會上傳任何資料
- **本機儲存** - 所有資料僅儲存在裝置本機
- **最小權限** - 僅請求必要的系統權限

### Q: 會不會影響系統穩定性？
**A**: 安全性考慮：
1. 使用系統標準的 Hook 機制
2. 對系統呼叫的影響最小化
3. 異常情況下自動降級處理
4. 不修改系統核心檔案

### Q: 隱私資料是否會洩露？
**A**: 隱私保護：
- **無資料收集** - 不收集任何個人資訊
- **無網路通訊** - 不與外部伺服器通訊
- **本機處理** - 所有分析在裝置本機進行
- **使用者控制** - 使用者完全控制所有資料

## 故障排除

### Q: 完全無法使用怎麼辦？
**A**: 重設步驟：
1. 在 Xposed 中停用模組
2. 重啟裝置
3. 清除 NoWakeLock 應用程式資料
4. 重新啟用模組並設定

### Q: 某些應用程式頻繁當機？
**A**: 緊急處理：
1. 立即停用該應用程式的所有規則
2. 檢查系統記錄中的錯誤資訊
3. 逐步恢復規則並觀察
4. 必要時將該應用程式加入白名單

### Q: 如何收集偵錯資訊？
**A**: 資訊收集：
```bash
# 裝置資訊
adb shell getprop ro.build.version.release
adb shell getprop ro.product.model

# 應用程式記錄
adb logcat | grep -i nowakelock

# Xposed 記錄
adb logcat | grep -i xposed
```

## 基礎概念

### Q: 什麼是 WakeLock/Alarm/Service？如何設定以獲得最佳效果？

**A**: 核心概念解釋：

**WakeLock（喚醒鎖）**：
- 防止裝置進入休眠狀態的機制
- 類型：PARTIAL（CPU執行）、SCREEN（螢幕常亮）等
- 官方文件：[Android WakeLock 指南](https://developer.android.com/training/scheduling/wakelock)

**Alarm（定時任務）**：
- 系統定時器，在特定時間觸發任務
- 類型：RTC、ELAPSED_REALTIME 等
- 官方文件：[Android Alarms 指南](https://developer.android.com/training/scheduling/alarms)

**Service（服務）**：
- 背景執行的應用程式元件
- 類型：前景服務、背景服務、綁定服務
- 官方文件：[Android Services 指南](https://developer.android.com/guide/components/services)

**推薦學習資源**：
- XDA 指南：["新手 WakeLock 完全指南"](https://forum.xda-developers.com)
- [Amplify](https://forum.xda-developers.com/t/mod-xposed-amplify-battery-extender-control-alarms-services-and-wakelocks.2853874/) - 提供 WakeLock/Alarm/Service 資訊參考清單
- [WakeBlock](https://github.com/MrLast98/WakeBlock) - 也提供 WakeLock 資訊

**注意**：很遺憾沒有完美的通用參考，每個裝置之間差異巨大。需要根據具體裝置和應用程式進行調整。

## 嚴重問題處理

### Q: 錯誤操作導致裝置無法啟動怎麼辦？

**A**: 緊急恢復步驟：

**情況1：NoWakeLock 模組導致的啟動問題**：

**方法1：硬體按鍵安全模式（推薦）**：
```bash
1. 長按電源鍵10秒強制重啟
2. 螢幕變黑後立即反覆按任意硬體按鍵（音量鍵或電源鍵）
3. 感受到2次短震動後，繼續快速按4次相同按鍵
4. 第4次按鍵後感受到長震動，表示 Xposed 已停用
5. 正常啟動後在 LSPosed 中停用 NoWakeLock 模組
```

**方法2：Recovery 檔案系統方法**：
```bash
1. 進入 TWRP Recovery
2. 點選 Advanced → File Manager
3. 導航到 /data/adb/lspd/
4. 刪除 config 資料夾
5. 重啟到系統
```

**方法3：裝置特定方法（如 Pixel）**：
```bash
開機時在 Google Logo 出現後立即瘋狂按音量下鍵
直到裝置震動確認進入安全模式
```

**情況2：誤攔截重要系統元件**：
```bash
1. 進入 Recovery → 檔案管理
2. 導航到 /data/misc/xxx-xxx-xxx/prefs/com.js.nowakelock
   # xxx-xxx-xxx 是一段很長的隨機字元串，每個裝置可能都不同
3. 刪除整個資料夾
4. 重啟裝置
5. 進入系統後恢復誤操作，如果不清楚具體問題，直接清除 NoWakeLock 資料
```

**不確定原因時**：
- 進入系統後直接清除 NoWakeLock 應用程式資料
- 重新設定，避免攔截系統關鍵元件

!!! danger "重要警告"
    修改系統關鍵元件前務必備份設定。建議從第三方應用程式開始偵錯，逐步調整系統服務。

## 隱私與安全

### Q: NoWakeLock 是否收集隱私資料？

**A**: 隱私保護承諾：
- **完全本機化** - 所有資料僅儲存在裝置本機
- **零資料上傳** - 不向任何伺服器上傳資料
- **無隱私收集** - 不收集或儲存任何個人資訊
- **開源透明** - 原始碼完全公開可審查

**未來可能的功能**：
- 可能新增可選的雲端設定同步功能
- 使用者可完全控制是否啟用
- 仍將堅持隱私保護原則

## 參與貢獻

### Q: 需要新功能或發現 Bug 怎麼辦？

**A**: 參與方式：
- **GitHub Issues** - [提交問題或功能請求](https://github.com/NoWakeLock/NoWakeLock/issues)
- **詳細描述** - 提供完整的問題描述和重現步驟
- **積極回饋** - 開發者會盡力處理所有回饋

### Q: 如何幫助更新翻譯？

**A**: 翻譯貢獻：
- **Pull Request** - 直接提交翻譯 PR
- **多語言支援** - 歡迎各種語言的翻譯貢獻
- **社群協作** - 可在社群群組討論翻譯細節

## 獲取幫助

### Q: 在哪裡報告問題？
**A**: 支援管道：
- **GitHub Issues** - 詳細的技術問題和功能請求
- **Telegram群** - [@nowakelock](https://t.me/nowakelock) 快速詢問和討論
- **Discord社群** - [NoWakelock](https://discord.gg/kewmG5AShQ) 深入的技術交流

### Q: 如何提供有效的問題報告？
**A**: 包含資訊：
1. **裝置資訊** - 品牌、型號、Android版本
2. **框架資訊** - Xposed框架類型和版本
3. **問題描述** - 具體的問題現象
4. **重現步驟** - 如何重現問題
5. **記錄資訊** - 相關的錯誤記錄
6. **截圖** - 問題介面的截圖

### Q: 多久能得到回覆？
**A**: 響應時間：
- **社群群組** - 通常幾小時內
- **GitHub Issues** - 1-3個工作日
- **緊急問題** - 會優先處理

!!! tip "使用建議"
    遇到問題時，建議先查閱文件和FAQ。如果問題仍然存在，請提供詳細資訊以便更好地協助解決。

!!! warning "重要提醒"
    使用前請備份重要資料。錯誤設定可能影響裝置正常執行，請謹慎操作。