# 更新記錄

本文件記錄 NoWakeLock 的版本更新歷史和重要變更。

## [v3.0.4 Build 81] - 2024-07-21

### 🌐 新增語言支援
- **德語 (Deutsch)** - 完整的德語介面支援
- **繁體中文** - 台灣地區繁體中文支援
- 語言選擇介面增加新語言選項
- 本地化字串資源完善

### 🔧 改進
- 優化語言切換體驗
- 完善多語言資源配置
- 改進本地化字串一致性

---

## [v3.0.3 Build 80] - 2024-05-20

### 🎉 重大更新
- **3.x 系列首個正式版本**，完全重構
- **Material Design 3** 全新介面設計
- **Android 7-15** 相容性支援
- **多使用者支援** 完整實作
- **事件追蹤系統** 全面升級

### ✨ 新功能
- **Jetpack Compose** UI 框架整合
- **應用程式統計** 功能增強
- **全域搜尋** 功能
- **模組檢測** 完善的狀態檢查
- **使用者管理** 多使用者環境支援

### ⚠️ 相容性說明
- **Samsung 裝置已知問題** - 部分功能可能受限
- **升級建議**：
  1. 卸載 v2.0.x 版本
  2. 重啟裝置
  3. 安裝 v3.x 版本
  4. 重啟裝置

### 🔄 設定遷移
- **v2.0 設定不相容** - 需要重新設定
- 建議在升級前備份重要設定
- 提供設定匯入匯出功能

---

## [v3.0.2 Build 77] - 2024-05-16

### ✨ 新功能
- **模組檢查功能** - 完整的模組狀態驗證
- **檢測介面優化** - 更清晰的狀態顯示
- **資料庫遷移策略** - 改進的版本升級處理

### 🐛 修復
- 修復模組檢測在某些裝置上的問題
- 改進資料庫升級流程
- 優化使用者介面響應速度

---

## [v3.0.1 Build 75-76] - 2024-05-05

### 🔧 改進
- **統一 Hook 策略** - Service、Alarm、WakeLock 處理優化
- **效能優化** - 減少系統資源佔用
- **程式碼重構** - 提高程式碼品質和可維護性

### 🐛 修復
- 修復在某些 Android 版本上的相容性問題
- 改進 Hook 穩定性
- 優化記憶體使用

---

## [v2.0.5 Build 62-63] - 2024-03

### ✨ 新功能
- **主題化啟動圖示** - 支援動態主題
- **錯誤處理改進** - ContentProvider 資料異常處理
- **Service Hook 更新** - 支援 Android API 29-40

### 🔧 改進
- 優化資料查詢效能
- 改進使用者介面響應
- 增強錯誤記錄記錄

---

## v2.x 系列 (歷史版本)

### 主要特性
- 基礎的 WakeLock/Alarm/Service 管理
- 傳統 UI 設計
- Android 7+ 基礎支援
- 單使用者環境

### 已知限制
- UI 設計相對簡單
- 功能相對基礎
- 不支援多使用者環境
- 與 v3.x 設定不相容

---

## 版本對比

### v3.x vs v2.x 主要差異

| 特性 | v2.x | v3.x |
|------|------|------|
| UI 框架 | 傳統 View | Jetpack Compose |
| 設計語言 | Material Design 2 | Material Design 3 |
| Android 支援 | 7-11 | 7-15 |
| 多使用者 | ❌ | ✅ |
| 模組檢測 | 基礎 | 完整 |
| 效能 | 一般 | 優化 |
| 設定相容性 | - | 不相容 v2.x |

### 升級建議

#### 從 v2.x 升級
1. **備份設定** - 記錄目前規則設定
2. **完全卸載** - 卸載 v2.x 並重啟
3. **全新安裝** - 安裝 v3.x 並重新設定
4. **逐步設定** - 根據備份逐步恢復設定

#### 新使用者
- 直接安裝最新的 v3.x 版本
- 按照[快速開始](../getting-started/quick-start.md)指南設定

---

## 已知問題

### v3.0.3 已知問題
- **Samsung 裝置** - 部分功能可能不穩定
- **Android 15** - 某些新特性可能不完全支援
- **記憶體使用** - 在低記憶體裝置上可能有效能影響

### 臨時解決方案
- Samsung 裝置建議使用保守設定
- Android 15 使用者請關注後續更新
- 低記憶體裝置建議減少規則數量

---

## 開發路線圖

### 短期計劃 (v3.1.x)
- Samsung 裝置相容性改進
- Android 15 完整支援
- 效能優化
- 更多預設設定範本

### 中期計劃 (v3.2.x)
- 雲端設定同步（可選）
- 更豐富的統計分析
- 外掛系統
- API 開放

### 長期計劃 (v4.x)
- 全新架構設計
- 更廣泛的裝置支援
- AI 輔助設定
- 企業版功能

---

## 獲取更新

### 官方管道
- [GitHub Releases](https://github.com/NoWakeLock/NoWakeLock/releases) - 最新版本
- [IzzyOnDroid](https://apt.izzysoft.de/fdroid/index/apk/com.js.nowakelock) - F-Droid 倉庫

### 版本類型
- **Stable** - 穩定版，推薦一般使用者
- **Beta** - 測試版，新功能搶先體驗
- **Dev** - 開發版，僅供開發測試

### 更新通知
- 應用程式內會提示新版本發布
- 關注 GitHub Releases 獲取最新資訊
- 加入社群群組獲取第一手消息

!!! info "版本策略"
    NoWakeLock 遵循語意化版本控制，重大更新會提前公告，確保使用者有充分的升級準備時間。

!!! warning "升級提醒"
    重大版本升級前請務必備份設定，某些版本間可能存在不相容的情況。