# 問題分析指南

在設定任何規則前，必須先確認裝置確實存在電池問題。本指南介紹如何使用工具分析和識別問題。

!!! warning "重要原則"
    只有透過資料分析確認某個 WakeLock/Alarm/Service 確實造成待機耗電問題後，才應該考慮進行限制。不要基於假設或預設進行設定。

## 資料分析工具

### 推薦分析工具

1. **BetterBatteryStats (BBS)** - 首選，提供最全面的分析
2. **NoWakeLock 內建統計** - BBS 不可用時的替代方案
3. **結合使用** - 獲得更準確的診斷結果

## 使用 BetterBatteryStats (BBS) 進行診斷

### 診斷步驟

1. **安裝 BBS** 並授予必要權限
2. **設定監控時間段** - 建議監控完整的待機週期
3. **分析關鍵資料**：
   - Kernel Wakelocks（系統級喚醒鎖）
   - Partial Wakelocks（應用程式級喚醒鎖）
   - 各應用程式的喚醒頻率和持續時間

### 問題識別標準

- 檢視裝置待機期間的異常喚醒活動
- 識別持續時間過長或頻率過高的 WakeLock
- 確認這些活動確實造成了電池消耗問題

## 使用 NoWakeLock 內建資料分析

**當 BBS 無法使用時**，可以使用 NoWakeLock 自身的統計資料：

### 資料檢視方式

1. **WakeLock 清單** - 檢視各應用程式的 WakeLock 活動統計
2. **按時長排序** - 識別持續時間異常長的 WakeLock
3. **按頻率排序** - 發現獲取頻率異常高的 WakeLock
4. **活躍狀態** - 監控目前正在持有的 WakeLock

### 異常識別標準

- 在裝置待機期間仍然顯示活躍的 WakeLock
- 單個 WakeLock 累計時長遠超其他同類應用程式
- 應用程式未使用時仍頻繁獲取 WakeLock
- 深夜時段的異常 WakeLock 活動

## 故障排查流程

### 第一步：確認問題存在

1. **使用分析工具監控** 一個完整的使用週期（至少24小時）
   - 優先使用 BBS 進行全面監控
   - BBS 不可用時使用 NoWakeLock 內建統計
2. **對比待機期間** 的 WakeLock 活動和電池消耗
3. **確認異常** - 尋找在不使用裝置時仍然活躍的 WakeLock

### 第二步：精確定位問題源

1. **識別具體應用程式和服務** 導致的異常 WakeLock
2. **分析模式** - 檢查是否是特定時間段或特定條件下的問題
3. **評估影響** - 確認該 WakeLock 對電池續航的實際影響程度

### 第三步：最小化干預

1. **優先考慮應用程式設定** - 檢查應用程式內是否有相關選項
2. **測試限制效果** - 使用限制模式而非完全攔截
3. **監控結果** - 設定後繼續監控效果

!!! tip "診斷要點"
    - 問題必須是實際存在的，而不是理論上的
    - 干預必須是針對性的，而不是預防性的
    - 每次設定後都要驗證應用程式功能是否正常

## 效果驗證

### 設定後監控

**必要步驟**：
1. **繼續資料監控** 設定後的效果
   - 優先使用 BBS 進行全面評估
   - 也可使用 NoWakeLock 內建統計作為參考
2. **驗證應用程式功能** - 確認應用程式的所有功能仍然正常
3. **評估電池改善** - 對比設定前後的實際電池消耗

**回滿準備**：
- 如果應用程式功能受影響，立即取消設定
- 如果電池改善不明顯，重新評估是否有必要限制

## 下一步

問題分析完成後：

1. [WakeLock 管理](../features/wakelocks.md) - 設定具體的 WakeLock 規則
2. [快速開始](quick-start.md) - 5分鐘快速設定指南
3. [常見問題](../reference/faq.md) - 遇到問題時的解決方案