# 模組檢查

模組檢查頁面幫助你驗證 NoWakeLock 是否正確安裝和執行。

## 檢查項目

### 基礎檢查

| 檢查項 | 說明 | 失敗原因 |
|--------|------|----------|
| **Xposed 框架啟用** | 檢測 Xposed 框架執行狀態 | 框架未安裝或未啟用 |
| **模組已載入** | 確認 NoWakeLock 被框架識別 | 模組未勾選或安裝失敗 |
| **模組已啟用** | 驗證模組在目標程序中執行 | 作用域設定錯誤 |

### 功能檢查

| 檢查項 | 說明 | 失敗原因 |
|--------|------|----------|
| **Hook 正常工作** | 驗證系統呼叫攔截功能 | 系統版本不相容 |
| **設定讀取成功** | 確認可以讀取設定 | 權限問題或儲存異常 |
| **資料庫正常** | 檢查資料庫讀寫功能 | 儲存空間不足或權限問題 |

【需要截圖：模組檢查頁面 - 全部成功】

## 狀態說明

### ✅ 正常狀態
所有檢查項顯示綠色圖示，表示模組工作正常。

### ❌ 異常狀態
紅色圖示表示存在問題，需要處理。

### ⚠️ 警告狀態
黃色圖示表示功能部分受限，但基本可用。

## 故障排除

### Xposed 框架問題

**症狀**: "Xposed 框架啟用"顯示❌

**解決步驟**:
1. 確認已安裝 LSPosed 或 EdXposed
2. 檢查框架管理器是否顯示"啟用"
3. 重啟裝置
4. 驗證框架版本相容性

### 模組載入問題

**症狀**: "模組已載入"顯示❌

**解決步驟**:
1. 開啟 Xposed 管理器
2. 進入"模組"頁面
3. 確認 NoWakeLock 已勾選
4. 重啟裝置
5. 重新檢查

### 作用域設定問題

**症狀**: "模組已啟用"顯示❌

**解決步驟**:
1. 開啟 LSPosed 管理器
2. 點擊 NoWakeLock 模組
3. 進入"作用域"設定
4. 確認已選擇：
   - `android` (系統框架)
   - `com.js.nowakelock` (應用程式本身)
5. 重啟裝置

【需要截圖：LSPosed 作用域設定】

### Hook 功能問題

**症狀**: "Hook 正常工作"顯示❌

**可能原因**:
- Android 版本不支援
- 系統客製化導致介面變更
- SELinux 策略限制

**解決方案**:
1. 檢查裝置相容性
2. 查看 Xposed 記錄：
   ```bash
   adb logcat | grep -i nowakelock
   ```
3. 嘗試重新安裝模組

### 設定讀取問題

**症狀**: "設定讀取成功"顯示❌

**解決步驟**:
1. 檢查儲存權限
2. 清除應用程式資料：
   ```bash
   # 註意：這會刪除所有設定
   adb shell pm clear com.js.nowakelock
   ```
3. 重新開啟應用程式

### 資料庫問題

**症狀**: "資料庫正常"顯示❌

**解決步驟**:
1. 檢查儲存空間
2. 驗證應用程式權限
3. 重設資料庫：
   - 設定 → 清除資料
   - 重新設定

## 進階檢查

### 查看系統記錄
```bash
# 查看 NoWakeLock 相關記錄
adb logcat | grep -i nowakelock

# 查看 Xposed 記錄
adb logcat | grep -i xposed
```

### 驗證 Hook 效果
1. 開啟任意應用程式
2. 切換到 WakeLock 頁面
3. 查看是否有新的 WakeLock 記錄

### 測試規則功能
1. 設定一個測試規則
2. 觸發對應的系統行為
3. 檢查統計資料是否更新

## 效能監控

### 資源使用
模組檢查頁面也顯示：
- CPU 使用率
- 記憶體佔用
- 儲存空間使用

### 效能指標

| 指標 | 正常範圍 | 說明 |
|------|----------|------|
| CPU 使用 | < 5% | Hook 處理開銷 |
| 記憶體佔用 | < 50MB | 快取和資料佔用 |
| 儲存使用 | < 100MB | 資料庫和記錄大小 |

## 定期檢查

### 建議頻率
- **首次安裝**: 每天檢查
- **穩定執行**: 每週檢查
- **系統更新後**: 立即檢查

### 自動檢查
應用程式啟動時會自動進行基礎檢查，異常時會顯示通知。

### 檢查記錄
應用程式保留最近 30 天的檢查記錄，可在設定中檢視。

## 聯繫支援

如果檢查持續失敗：

1. **收集資訊**:
   - 裝置型號和 Android 版本
   - Xposed 框架類型和版本
   - 檢查頁面截圖

2. **獲取記錄**:
   ```bash
   adb logcat -v time > nowakelock_log.txt
   ```

3. **尋求幫助**:
   - [GitHub Issues](https://github.com/NoWakeLock/NoWakeLock/issues)
   - [Telegram 群組](https://t.me/nowakelock)
   - [Discord 社群](https://discord.gg/kewmG5AShQ)

!!! warning "重要提醒"
    模組檢查失敗時，NoWakeLock 功能可能無法正常工作。請務必解決所有問題後再進行設定。