# WakeLock 管理

WakeLock（喚醒鎖）阻止裝置進入休眠狀態，是 Android 系統中影響電池續航的關鍵機制。

!!! danger "⚠️ 救援模式 - 重要提醒！"
    **如果錯誤設定 WakeLock 導致裝置無法啟動**：
    
    **情況1：LSPosed 框架問題（安裝後未設定就遇到問題）**：
    1. 長按電源鍵10秒強制重啟
    2. 螢幕變黑後立即反覆按任意硬體按鍵
    3. 感受到2次短震動後，繼續快速按4次相同按鍵
    4. 第4次按鍵後感受到長震動，表示 LSPosed 已停用
    5. 正常啟動後在 LSPosed 中停用 NoWakeLock 模組
    
    **情況2：誤操作設定問題（可進入 Recovery）**：
    1. 進入 Recovery → 檔案管理
    2. 導航到 /data/misc/xxx-xxx-xxx/prefs/com.js.nowakelock
       （xxx-xxx-xxx 是一段很長的隨機字元串，每個裝置可能都不同）
    3. 刪除整個資料夾
    4. 重啟裝置
    
    **不確定原因時**：直接清除 NoWakeLock 應用程式資料，重新設定時避免攔截系統關鍵元件。

## WakeLock 類型

### 主要類型

| 類型 | 常數值 | 說明 | 電量影響 |
|------|--------|------|----------|
| PARTIAL_WAKE_LOCK | 1 | 保持 CPU 執行 | 高 |
| SCREEN_DIM_WAKE_LOCK | 6 | 螢幕變暗但不關閉 (已廢棄) | 中等 |
| SCREEN_BRIGHT_WAKE_LOCK | 10 | 螢幕保持亮度 (已廢棄) | 高 |
| FULL_WAKE_LOCK | 26 | CPU + 螢幕全亮 (已廢棄) | 極高 |
| PROXIMITY_SCREEN_OFF_WAKE_LOCK | 32 | 接近傳感器控制 | 低 |

!!! warning "類型說明"
    除 PARTIAL_WAKE_LOCK 和 PROXIMITY_SCREEN_OFF_WAKE_LOCK 外，其他類型在 Android API 17 後已被廢棄。現代應用程式主要使用 PARTIAL_WAKE_LOCK。

### 特殊標識

**系統 WakeLock**：
- `PowerManagerService.WakeLocks`
- `AlarmManager`
- `AudioMix`

**網路相關**：
- `WifiManager`
- `ConnectivityService`

**定位服務**：
- `LocationManagerService`
- `GpsLocationProvider`

## 介面說明

### WakeLock 清單

【需要截圖：WakeLock 清單頁面】

**清單資訊**：
- **名稱** - WakeLock 識別符
- **應用程式** - 來源包名
- **類型** - WakeLock 類型圖示
- **狀態** - 目前狀態指示器
- **統計** - 獲取次數和累計時長

### 狀態指示器

| 狀態 | 圖示 | 說明 |
|------|------|------|
| 允許 | 🟢 | 正常執行，不做限制 |
| 限制 | 🟡 | 設定了超時時間 |
| 攔截 | 🔴 | 完全阻止獲取 |
| 活躍 | ⚡ | 目前正在持有 |

### 篩選和排序

**篩選選項**：
- 全部
- 允許
- 限制  
- 攔截
- 目前活躍

**排序方式**：
- 按名稱
- 按應用程式
- 按獲取次數
- 按累計時長
- 按最後活動時間

## 設定選項

### 處理模式

#### 允許模式
- 不進行任何限制
- WakeLock 正常獲取和釋放
- 預設模式，適用於大部分情況

#### 限制模式
- 設定最大持有時間
- 超時後強制釋放
- 僅在透過 BBS 確認某個 WakeLock 持續時間過長時使用

!!! warning "超時設定原則"
    超時時間必須根據 BBS 分析的實際資料確定，而不是使用預設值。觀察該 WakeLock 的正常持續時間，然後設定稍大於正常值的超時。

#### 攔截模式
- 完全阻止 WakeLock 獲取
- 應用程式無法持有該 WakeLock
- 僅在確認該 WakeLock 完全不必要且嚴重影響電池時使用

## 使用方法

### 基本操作流程

!!! warning "重要：設定前必讀"
    1. **先診斷，後設定** - 使用 BBS 確認問題後再進行設定
    2. **單個處理** - 針對具體問題逐個設定，避免批量操作
    3. **持續監控** - 設定後繼續使用 BBS 驗證效果

### 檢視和分析 WakeLock

1. 點擊底部"Wakelocks"標籤
2. 瀏覽目前清單和統計資料
3. 結合 BBS 資料分析異常項目

### 針對性設定

1. **確認問題** - 基於 BBS 分析結果
2. **點擊目標 WakeLock** 進入設定頁面
3. **選擇最小干預** - 優先選擇限制模式
4. **設定參數** - 基於實際觀察到的資料
5. **驗證功能** - 確認應用程式功能正常

!!! danger "禁止批量設定"
    不要使用批量操作功能進行預設設定。每個 WakeLock 的問題都是具體的，需要個別分析和處理。

## 效果驗證

### 設定後監控

**必要步驟**：
1. **繼續資料監控** 設定後的效果
   - 優先使用 BBS 進行全面評估
   - 也可使用 NoWakeLock 內建統計作為參考
2. **驗證應用程式功能** - 確認應用程式的所有功能仍然正常
3. **評估電池改善** - 對比設定前後的實際電池消耗

**回滾準備**：
- 如果應用程式功能受影響，立即取消設定
- 如果電池改善不明顯，重新評估是否有必要限制

## 技術細節

### Hook 實作

NoWakeLock 攔截 PowerManagerService 中的關鍵方法：

```kotlin
// 主要 Hook 方法 (參數因 Android 版本而異)
acquireWakeLockInternal(...)
releaseWakeLockInternal(...)
```

**版本相容性處理**：
- 使用參數位置快取機制
- 支援 Android 7.0-15.0 的不同方法簽名
- 自動檢測和適配參數位置

### 相容性處理

**版本適配**：
- 支援 Android 7.0-15.0
- 動態參數位置檢測
- 降級策略處理

**效能優化**：
- Hook 呼叫開銷 < 1ms
- 規則匹配使用快取
- 異步處理統計資料

### 資料儲存

**即時資料**：
- 目前活躍的 WakeLock
- 記憶體中快取，重啟後清除

**會話統計**：
- 目前會話的 WakeLock 活動記錄
- 資料庫臨時儲存，裝置重啟後清空

## 相關功能

- [應用程式管理](app-management.md) - 按應用程式檢視所有 WakeLock
- [規則系統](rules-regex.md) - 使用正則表示式批量設定

!!! warning "使用建議"
    修改系統關鍵服務的 WakeLock 可能影響裝置穩定性。建議從第三方應用程式開始，逐步調整系統服務。