# Service 管理

Service（背景服務）是 Android 應用程式在背景執行長時間執行任務的元件，過多的背景服務會消耗系統資源和電量。

!!! danger "⚠️ 救援模式 - 重要提醒！"
    **如果錯誤設定 WakeLock 導致裝置無法啟動**：
    
    **情況1：LSPosed 框架問題（安裝後未設定就遇到問題）**：
    1. 長按電源鍵10秒強制重啟
    2. 螢幕變黑後立即反覆按任意硬體按鍵
    3. 感受到2次短震動後，繼續快速按4次相同按鍵
    4. 第4次按鍵後感受到長震動，表示 LSPosed 已停用
    5. 正常啟動後在 LSPosed 中停用 NoWakeLock 模組
    
    **情況2：誤操作設定問題（可進入 Recovery）**：
    1. 進入 Recovery → 檔案管理
    2. 導航到 /data/misc/xxx-xxx-xxx/prefs/com.js.nowakelock
       （xxx-xxx-xxx 是一段很長的隨機字元串，每個裝置可能都不同）
    3. 刪除整個資料夾
    4. 重啟裝置
    
    **不確定原因時**：直接清除 NoWakeLock 應用程式資料，重新設定時避免攔截系統關鍵元件。

## 功能概述

### Service 作用
- 背景資料處理
- 網路通信和下載
- 音樂播放等媒體服務
- 系統監控和維護

### 管理目標
- 監控服務啟動和繫定行為
- 控制不必要的背景服務
- 優化服務啟動頻率
- 減少資源佔用

## 介面說明

### Service 清單

【需要截圖：Service 清單頁面】

**清單資訊**：
- **服務名** - Service 類名
- **應用程式** - 來源包名
- **類型** - 服務類型圖示
- **狀態** - 執行狀態和攔截設定
- **統計** - 啟動次數和執行時長

### 狀態指示

| 狀態 | 圖示 | 說明 |
|------|------|------|
| 允許 | 🟢 | 正常啟動和執行 |
| 限制 | 🟡 | 限制啟動頻率 |
| 攔截 | 🔴 | 阻止啟動 |
| 執行中 | ▶️ | 目前正在執行 |
| 已停止 | ⏹️ | 服務已停止 |

### 服務類型

**前景服務**：
- 顯示持續通知
- 使用者可感知的服務
- 如音樂播放、導航

**背景服務**：
- 無使用者介面
- 靜默執行任務
- 如資料同步、清理

**繫定服務**：
- 與其他元件繫定
- 提供介面呼叫
- 生命週期與繫定者關聯

## 設定選項

### 處理模式

#### 允許模式
- 服務正常啟動和執行
- 不進行任何限制
- 適用於重要功能服務

#### 限制模式
- 控制啟動頻率
- 限制同時執行數量
- 自動停止長時間執行的服務

#### 攔截模式
- 完全阻止服務啟動
- 包括顯式和隱式啟動
- 可能影響應用程式核心功能

### 進階選項

**智慧調度**：
- 延遲非緊急服務啟動
- 合併相似功能的服務
- 根據系統負載調整

**資源限制**：
- CPU 使用率限制
- 記憶體佔用控制
- 網路流量限制

## 使用方法

### 檢視 Service 清單

1. 點擊底部"Services"標籤
2. 檢視所有檢測到的服務
3. 使用篩選檢視特定狀態或應用程式

### 設定服務規則

1. 點擊目標服務項目
2. 選擇處理模式
3. 設定具體限制參數：
   - 啟動間隔時間
   - 最大執行時長
   - 資源使用限制

【需要截圖：Service 設定頁面】

### 批量管理

**按應用程式篩選**：
- 檢視特定應用程式的所有服務
- 批量設定應用程式級規則

**按類型篩選**：
- 前景服務單獨管理
- 背景服務統一限制

## 實際應用

### 問題識別

#### 異常服務特徵

**頻繁啟動**：
- 啟動間隔小於 10 秒
- 短時間內重複啟動同一服務
- 應用程式未使用時仍在啟動服務

**資源消耗**：
- 長時間執行（超過 30 分鐘）
- 高 CPU 使用率（> 5%）
- 大量記憶體佔用（> 100MB）

**無效服務**：
- 啟動後立即停止
- 無實際功能的空服務
- 僅用於保活的服務

## 技術實現

### Hook 機制

攔截 ActivityManagerService 的服務管理方法：
```kotlin
// 服務啟動攔截
startServiceLocked(
    IApplicationThread caller,
    Intent service,
    String resolvedType,
    int callingPid,
    int callingUid,
    boolean fgRequired,
    String callingPackage,
    int userId
)

// 服務繫定攔截  
bindServiceLocked(
    IApplicationThread caller,
    IBinder token,
    Intent service,
    String resolvedType,
    IServiceConnection connection,
    int flags,
    String callingPackage,
    int userId
)
```

### 資料追蹤

**即時監控**：
- 服務啟動時記錄資訊
- 追蹤服務執行狀態
- 計算資源使用情況

**歷史統計**：
- 資料庫儲存服務歷史
- 分析啟動模式和走勢
- 生成優化建議

### 相容性處理

**版本適配**：
- Android 8.0+ 背景服務限制適配
- 不同版本的 API 差異處理
- 前景服務特殊處理

**效能優化**：
- 最小化 Hook 呼叫開銷
- 高效的規則匹配
- 異步處理統計資料

## 相關功能

- [應用程式管理](app-management.md) - 按應用程式檢視所有服務
- [WakeLock 管理](wakelocks.md) - 服務相關的 WakeLock
- [規則系統](rules-regex.md) - 使用正則表示式批量設定

!!! info "Android 8.0+ 變化"
    Android 8.0 開始限制背景服務，系統會自動停止大部分背景服務。NoWakeLock 的服務管理主要針對前景服務和繫定服務。

!!! warning "謹慎處理"
    攔截關鍵服務可能導致應用程式功能異常。建議先使用限制模式，確認無影響後再考慮攔截。