# 應用程式管理

應用程式管理功能允許你按應用程式檢視和設定所有的 WakeLock、Alarm 和 Service，提供應用程式維度的統一管理視圖。

## 功能概述

### 核心功能
- 按應用程式分類顯示所有活動
- 應用程式級別的統計資訊
- 批量設定應用程式的所有元件
- 應用程式行為模式分析

### 管理優勢
- 統一的應用程式視角
- 便於識別問題應用程式
- 簡化批量設定流程
- 直觀的對比分析

## 介面說明

### 應用程式清單

【需要截圖：應用程式清單頁面】

**顯示資訊**：
- **應用程式圖示和名稱**
- **包名** - 應用程式唯一標識
- **統計摘要** - WakeLock/Alarm/Service 數量
- **活躍狀態** - 最近活動指示器
- **使用者** - 多使用者環境下的使用者標識

### 統計卡片

每個應用程式顯示三類統計：

| 類型 | 指標 | 說明 |
|------|------|------|
| WakeLock | 計數/時長 | 獲取次數和累計持有時間 |
| Alarm | 計數/頻率 | 觸發次數和平均間隔 |
| Service | 計數/時長 | 啟動次數和執行時間 |

### 篩選和排序

**篩選選項**：
- 全部應用程式
- 系統應用程式
- 使用者應用程式
- 有活動的應用程式
- 已設定規則的應用程式

**排序方式**：
- 按應用程式名稱
- 按安裝時間
- 按活動頻率
- 按資源消耗
- 按設定狀態

## 應用程式詳情頁面

### 進入詳情頁
1. 點擊應用程式清單中的任意應用程式
2. 進入應用程式詳情頁面

【需要截圖：應用程式詳情頁面】

### 詳情頁內容

#### 應用程式資訊
- 應用程式名稱、版本、包名
- 安裝時間、更新時間
- 權限清單
- 目前執行狀態

#### 活動統計
- **時間線圖表** - 12小時活動走勢
- **分類統計** - WakeLock/Alarm/Service 詳細資料
- **資源消耗** - CPU、記憶體、電量使用

#### 元件清單
按標籤頁分類顯示：
- **WakeLocks** - 該應用程式的所有 WakeLock
- **Alarms** - 該應用程式的所有 Alarm
- **Services** - 該應用程式的所有 Service

## 設定功能

### 應用程式級設定

#### 全域設定
為應用程式設定統一規則：
```
允許模式：
- 所有元件正常執行
- 適用於重要應用程式

限制模式：
- 統一的時間限制
- 適用於一般應用程式

攔截模式：
- 阻止所有背景活動
- 適用於問題應用程式
```

#### 繼承機制
- 元件級別可繼承應用程式設定
- 支援個別元件的例外設定
- 優先級：元件設定 > 應用程式設定 > 全域預設

## 多使用者支援

### 使用者切換
在多使用者裝置上：
1. 頂部使用者選擇器
2. 切換檢視不同使用者的應用程式
3. 每個使用者獨立的設定

【需要截圖：使用者切換介面】

### 使用者隔離
- 各使用者的設定互不影響
- 系統應用程式在所有使用者間共享
- 使用者應用程式僅在對應使用者下顯示

## 匯入匯出

### 設定備份

#### 匯出設定
```json
{
  "version": "3.0",
  "timestamp": "2024-01-01T00:00:00Z",
  "user_id": 0,
  "apps": [
    {
      "package_name": "com.example.app",
      "app_config": {
        "mode": "limit",
        "wakelock_timeout": 60000
      },
      "components": [
        {
          "type": "wakelock",
          "name": "ExampleWakeLock",
          "mode": "allow"
        }
      ]
    }
  ]
}
```

#### 匯入設定
- 支援完整設定匯入
- 選擇性匯入特定應用程式
- 衝突處理策略選擇

## 相關功能

- [WakeLock 管理](wakelocks.md) - 詳細的 WakeLock 控制
- [Alarm 管理](alarms.md) - 詳細的 Alarm 控制
- [Service 管理](services.md) - 詳細的 Service 控制
- [規則系統](rules-regex.md) - 使用正則表示式批量設定

!!! tip "使用建議"
    應用程式管理是 NoWakeLock 的入口功能，建議新使用者從這裡開始了解各應用程式的行為模式，再進行針對性優化。