# 更新日志

本文档记录 NoWakeLock 的版本更新历史和重要变更。

## [v3.0.4 Build 81] - 2024-07-21

### 🌐 新增语言支持
- **德语 (Deutsch)** - 完整的德语界面支持
- **繁体中文** - 台湾地区繁体中文支持
- 语言选择界面增加新语言选项
- 本地化字符串资源完善

### 🔧 改进
- 优化语言切换体验
- 完善多语言资源配置
- 改进本地化字符串一致性

---

## [v3.0.3 Build 80] - 2024-05-20

### 🎉 重大更新
- **3.x 系列首个正式版本**，完全重构
- **Material Design 3** 全新界面设计
- **Android 7-15** 兼容性支持
- **多用户支持** 完整实现
- **事件追踪系统** 全面升级

### ✨ 新功能
- **Jetpack Compose** UI 框架集成
- **应用统计** 功能增强
- **全局搜索** 功能
- **模块检测** 完善的状态检查
- **用户管理** 多用户环境支持

### ⚠️ 兼容性说明
- **Samsung 设备已知问题** - 部分功能可能受限
- **升级建议**：
  1. 卸载 v2.0.x 版本
  2. 重启设备
  3. 安装 v3.x 版本
  4. 重启设备

### 🔄 配置迁移
- **v2.0 配置不兼容** - 需要重新配置
- 建议在升级前备份重要配置
- 提供配置导入导出功能

---

## [v3.0.2 Build 77] - 2024-05-16

### ✨ 新功能
- **模块检查功能** - 完整的模块状态验证
- **检测界面优化** - 更清晰的状态显示
- **数据库迁移策略** - 改进的版本升级处理

### 🐛 修复
- 修复模块检测在某些设备上的问题
- 改进数据库升级流程
- 优化用户界面响应速度

---

## [v3.0.1 Build 75-76] - 2024-05-05

### 🔧 改进
- **统一 Hook 策略** - Service、Alarm、WakeLock 处理优化
- **性能优化** - 减少系统资源占用
- **代码重构** - 提高代码质量和可维护性

### 🐛 修复
- 修复在某些 Android 版本上的兼容性问题
- 改进 Hook 稳定性
- 优化内存使用

---

## [v2.0.5 Build 62-63] - 2024-03

### ✨ 新功能
- **主题化启动图标** - 支持动态主题
- **错误处理改进** - ContentProvider 数据异常处理
- **Service Hook 更新** - 支持 Android API 29-40

### 🔧 改进
- 优化数据查询性能
- 改进用户界面响应
- 增强错误日志记录

---

## v2.x 系列 (历史版本)

### 主要特性
- 基础的 WakeLock/Alarm/Service 管理
- 传统 UI 设计
- Android 7+ 基础支持
- 单用户环境

### 已知限制
- UI 设计相对简单
- 功能相对基础
- 不支持多用户环境
- 与 v3.x 配置不兼容

---

## 版本对比

### v3.x vs v2.x 主要差异

| 特性 | v2.x | v3.x |
|------|------|------|
| UI 框架 | 传统 View | Jetpack Compose |
| 设计语言 | Material Design 2 | Material Design 3 |
| Android 支持 | 7-11 | 7-15 |
| 多用户 | ❌ | ✅ |
| 模块检测 | 基础 | 完整 |
| 性能 | 一般 | 优化 |
| 配置兼容性 | - | 不兼容 v2.x |

### 升级建议

#### 从 v2.x 升级
1. **备份配置** - 记录当前规则设置
2. **完全卸载** - 卸载 v2.x 并重启
3. **全新安装** - 安装 v3.x 并重新配置
4. **逐步配置** - 根据备份逐步恢复设置

#### 新用户
- 直接安装最新的 v3.x 版本
- 按照[快速开始](../getting-started/quick-start.md)指南配置

---

## 已知问题

### v3.0.3 已知问题
- **Samsung 设备** - 部分功能可能不稳定
- **Android 15** - 某些新特性可能不完全支持
- **内存使用** - 在低内存设备上可能有性能影响

### 临时解决方案
- Samsung 设备建议使用保守配置
- Android 15 用户请关注后续更新
- 低内存设备建议减少规则数量

---

## 开发路线图

### 短期计划 (v3.1.x)
- Samsung 设备兼容性改进
- Android 15 完整支持
- 性能优化
- 更多预设配置模板

### 中期计划 (v3.2.x)
- 云端配置同步（可选）
- 更丰富的统计分析
- 插件系统
- API 开放

### 长期计划 (v4.x)
- 全新架构设计
- 更广泛的设备支持
- AI 辅助配置
- 企业版功能

---

## 获取更新

### 官方渠道
- [GitHub Releases](https://github.com/NoWakeLock/NoWakeLock/releases) - 最新版本
- [IzzyOnDroid](https://apt.izzysoft.de/fdroid/index/apk/com.js.nowakelock) - F-Droid 仓库

### 版本类型
- **Stable** - 稳定版，推荐一般用户
- **Beta** - 测试版，新功能抢先体验
- **Dev** - 开发版，仅供开发测试

### 更新通知
- 应用内会提示新版本发布
- 关注 GitHub Releases 获取最新信息
- 加入社区群组获取第一手消息

!!! info "版本策略"
    NoWakeLock 遵循语义化版本控制，重大更新会提前公告，确保用户有充分的升级准备时间。

!!! warning "升级提醒"
    重大版本升级前请务必备份配置，某些版本间可能存在不兼容的情况。