# 问题分析指南

在配置任何规则前，必须先确认设备确实存在电池问题。本指南介绍如何使用工具分析和识别问题。

!!! warning "重要原则"
    只有通过数据分析确认某个 WakeLock/Alarm/Service 确实造成待机耗电问题后，才应该考虑进行限制。不要基于假设或预设进行配置。

## 数据分析工具

### 推荐分析工具

1. **BetterBatteryStats (BBS)** - 首选，提供最全面的分析
2. **NoWakeLock 内置统计** - BBS 不可用时的替代方案
3. **结合使用** - 获得更准确的诊断结果

## 使用 BetterBatteryStats (BBS) 进行诊断

### 诊断步骤

1. **安装 BBS** 并授予必要权限
2. **设置监控时间段** - 建议监控完整的待机周期
3. **分析关键数据**：
   - Kernel Wakelocks（系统级唤醒锁）
   - Partial Wakelocks（应用级唤醒锁）
   - 各应用的唤醒频率和持续时间

### 问题识别标准

- 查看设备待机期间的异常唤醒活动
- 识别持续时间过长或频率过高的 WakeLock
- 确认这些活动确实造成了电池消耗问题

## 使用 NoWakeLock 内置数据分析

**当 BBS 无法使用时**，可以使用 NoWakeLock 自身的统计数据：

### 数据查看方式

1. **WakeLock 列表** - 查看各应用的 WakeLock 活动统计
2. **按时长排序** - 识别持续时间异常长的 WakeLock
3. **按频率排序** - 发现获取频率异常高的 WakeLock
4. **活跃状态** - 监控当前正在持有的 WakeLock

### 异常识别标准

- 在设备待机期间仍然显示活跃的 WakeLock
- 单个 WakeLock 累计时长远超其他同类应用
- 应用未使用时仍频繁获取 WakeLock
- 深夜时段的异常 WakeLock 活动

## 故障排查流程

### 第一步：确认问题存在

1. **使用分析工具监控** 一个完整的使用周期（至少24小时）
   - 优先使用 BBS 进行全面监控
   - BBS 不可用时使用 NoWakeLock 内置统计
2. **对比待机期间** 的 WakeLock 活动和电池消耗
3. **确认异常** - 寻找在不使用设备时仍然活跃的 WakeLock

### 第二步：精确定位问题源

1. **识别具体应用和服务** 导致的异常 WakeLock
2. **分析模式** - 检查是否是特定时间段或特定条件下的问题
3. **评估影响** - 确认该 WakeLock 对电池续航的实际影响程度

### 第三步：最小化干预

1. **优先考虑应用设置** - 检查应用内是否有相关选项
2. **测试限制效果** - 使用限制模式而非完全拦截
3. **监控结果** - 配置后继续监控效果

!!! tip "诊断要点"
    - 问题必须是实际存在的，而不是理论上的
    - 干预必须是针对性的，而不是预防性的
    - 每次配置后都要验证应用功能是否正常

## 效果验证

### 配置后监控

**必要步骤**：
1. **继续数据监控** 配置后的效果
   - 优先使用 BBS 进行全面评估
   - 也可使用 NoWakeLock 内置统计作为参考
2. **验证应用功能** - 确认应用的所有功能仍然正常
3. **评估电池改善** - 对比配置前后的实际电池消耗

**回滚准备**：
- 如果应用功能受影响，立即取消配置
- 如果电池改善不明显，重新评估是否有必要限制

## 下一步

问题分析完成后：

1. [WakeLock 管理](../features/wakelocks.md) - 配置具体的 WakeLock 规则
2. [快速开始](quick-start.md) - 5分钟快速配置指南
3. [常见问题](../reference/faq.md) - 遇到问题时的解决方案