# 模块检查

模块检查页面帮助你验证 NoWakeLock 是否正确安装和运行。

## 检查项目

### 基础检查

| 检查项 | 说明 | 失败原因 |
|--------|------|----------|
| **Xposed 框架激活** | 检测 Xposed 框架运行状态 | 框架未安装或未激活 |
| **模块已加载** | 确认 NoWakeLock 被框架识别 | 模块未勾选或安装失败 |
| **模块已激活** | 验证模块在目标进程中运行 | 作用域配置错误 |

### 功能检查

| 检查项 | 说明 | 失败原因 |
|--------|------|----------|
| **Hook 正常工作** | 验证系统调用拦截功能 | 系统版本不兼容 |
| **配置读取成功** | 确认可以读取设置 | 权限问题或存储异常 |
| **数据库正常** | 检查数据库读写功能 | 存储空间不足或权限问题 |

【需要截图：模块检查页面 - 全部成功】

## 状态说明

### ✅ 正常状态
所有检查项显示绿色图标，表示模块工作正常。

### ❌ 异常状态
红色图标表示存在问题，需要处理。

### ⚠️ 警告状态
黄色图标表示功能部分受限，但基本可用。

## 故障排除

### Xposed 框架问题

**症状**: "Xposed 框架激活"显示❌

**解决步骤**:
1. 确认已安装 LSPosed 或 EdXposed
2. 检查框架管理器是否显示"激活"
3. 重启设备
4. 验证框架版本兼容性

### 模块加载问题

**症状**: "模块已加载"显示❌

**解决步骤**:
1. 打开 Xposed 管理器
2. 进入"模块"页面
3. 确认 NoWakeLock 已勾选
4. 重启设备
5. 重新检查

### 作用域配置问题

**症状**: "模块已激活"显示❌

**解决步骤**:
1. 打开 LSPosed 管理器
2. 点击 NoWakeLock 模块
3. 进入"作用域"设置
4. 确认已选择：
   - `android` (系统框架)
   - `com.js.nowakelock` (应用本身)
5. 重启设备

【需要截图：LSPosed 作用域配置】

### Hook 功能问题

**症状**: "Hook 正常工作"显示❌

**可能原因**:
- Android 版本不支持
- 系统定制导致接口变更
- SELinux 策略限制

**解决方案**:
1. 检查设备兼容性
2. 查看 Xposed 日志：
   ```bash
   adb logcat | grep -i nowakelock
   ```
3. 尝试重新安装模块

### 配置读取问题

**症状**: "配置读取成功"显示❌

**解决步骤**:
1. 检查存储权限
2. 清除应用数据：
   ```bash
   # 注意：这会删除所有配置
   adb shell pm clear com.js.nowakelock
   ```
3. 重新打开应用

### 数据库问题

**症状**: "数据库正常"显示❌

**解决步骤**:
1. 检查存储空间
2. 验证应用权限
3. 重置数据库：
   - 设置 → 清除数据
   - 重新配置

## 高级检查

### 查看系统日志
```bash
# 查看 NoWakeLock 相关日志
adb logcat | grep -i nowakelock

# 查看 Xposed 日志
adb logcat | grep -i xposed
```

### 验证 Hook 效果
1. 打开任意应用
2. 切换到 WakeLock 页面
3. 查看是否有新的 WakeLock 记录

### 测试规则功能
1. 设置一个测试规则
2. 触发对应的系统行为
3. 检查统计数据是否更新

## 性能监控

### 资源使用
模块检查页面也显示：
- CPU 使用率
- 内存占用
- 存储空间使用

### 性能指标

| 指标 | 正常范围 | 说明 |
|------|----------|------|
| CPU 使用 | < 5% | Hook 处理开销 |
| 内存占用 | < 50MB | 缓存和数据占用 |
| 存储使用 | < 100MB | 数据库和日志大小 |

## 定期检查

### 建议频率
- **首次安装**: 每天检查
- **稳定运行**: 每周检查
- **系统更新后**: 立即检查

### 自动检查
应用启动时会自动进行基础检查，异常时会显示通知。

### 检查记录
应用保留最近 30 天的检查记录，可在设置中查看。

## 联系支持

如果检查持续失败：

1. **收集信息**:
   - 设备型号和 Android 版本
   - Xposed 框架类型和版本
   - 检查页面截图

2. **获取日志**:
   ```bash
   adb logcat -v time > nowakelock_log.txt
   ```

3. **寻求帮助**:
   - [GitHub Issues](https://github.com/NoWakeLock/NoWakeLock/issues)
   - [Telegram 群组](https://t.me/nowakelock)
   - [Discord 社区](https://discord.gg/kewmG5AShQ)

!!! warning "重要提醒"
    模块检查失败时，NoWakeLock 功能可能无法正常工作。请务必解决所有问题后再进行配置。