# Service 管理

Service（后台服务）是 Android 应用在后台执行长时间运行任务的组件，过多的后台服务会消耗系统资源和电量。

!!! danger "⚠️ 救援模式 - 重要提醒！"
    **如果错误配置 WakeLock 导致设备无法启动**：
    
    **情况1：LSPosed 框架问题（安装后未配置就遇到问题）**：
    1. 长按电源键10秒强制重启
    2. 屏幕变黑后立即反复按任意硬件按键
    3. 感受到2次短震动后，继续快速按4次相同按键
    4. 第4次按键后感受到长震动，表示 LSPosed 已禁用
    5. 正常启动后在 LSPosed 中禁用 NoWakeLock 模块
    
    **情况2：误操作配置问题（可进入 Recovery）**：
    1. 进入 Recovery → 文件管理
    2. 导航到 /data/misc/xxx-xxx-xxx/prefs/com.js.nowakelock
       （xxx-xxx-xxx 是一段很长的随机字符串，每个设备可能都不同）
    3. 删除整个文件夹
    4. 重启设备
    
    **不确定原因时**：直接清除 NoWakeLock 应用数据，重新配置时避免拦截系统关键组件。

## 功能概述

### Service 作用
- 后台数据处理
- 网络通信和下载
- 音乐播放等媒体服务
- 系统监控和维护

### 管理目标
- 监控服务启动和绑定行为
- 控制不必要的后台服务
- 优化服务启动频率
- 减少资源占用

## 界面说明

### Service 列表

【需要截图：Service 列表页面】

**列表信息**：
- **服务名** - Service 类名
- **应用** - 来源包名
- **类型** - 服务类型图标
- **状态** - 运行状态和拦截设置
- **统计** - 启动次数和运行时长

### 状态指示

| 状态 | 图标 | 说明 |
|------|------|------|
| 允许 | 🟢 | 正常启动和运行 |
| 限制 | 🟡 | 限制启动频率 |
| 拦截 | 🔴 | 阻止启动 |
| 运行中 | ▶️ | 当前正在运行 |
| 已停止 | ⏹️ | 服务已停止 |

### 服务类型

**前台服务**：
- 显示持续通知
- 用户可感知的服务
- 如音乐播放、导航

**后台服务**：
- 无用户界面
- 静默执行任务
- 如数据同步、清理

**绑定服务**：
- 与其他组件绑定
- 提供接口调用
- 生命周期与绑定者关联

## 配置选项

### 处理模式

#### 允许模式
- 服务正常启动和运行
- 不进行任何限制
- 适用于重要功能服务

#### 限制模式
- 控制启动频率
- 限制同时运行数量
- 自动停止长时间运行的服务

#### 拦截模式
- 完全阻止服务启动
- 包括显式和隐式启动
- 可能影响应用核心功能

### 高级选项

**智能调度**：
- 延迟非紧急服务启动
- 合并相似功能的服务
- 根据系统负载调整

**资源限制**：
- CPU 使用率限制
- 内存占用控制
- 网络流量限制

## 使用方法

### 查看 Service 列表

1. 点击底部"Services"标签
2. 查看所有检测到的服务
3. 使用筛选查看特定状态或应用

### 配置服务规则

1. 点击目标服务项目
2. 选择处理模式
3. 设置具体限制参数：
   - 启动间隔时间
   - 最大运行时长
   - 资源使用限制

【需要截图：Service 配置页面】

### 批量管理

**按应用筛选**：
- 查看特定应用的所有服务
- 批量设置应用级规则

**按类型筛选**：
- 前台服务单独管理
- 后台服务统一限制

## 实际应用

### 问题识别

#### 异常服务特征

**频繁启动**：
- 启动间隔小于 10 秒
- 短时间内重复启动同一服务
- 应用未使用时仍在启动服务

**资源消耗**：
- 长时间运行（超过 30 分钟）
- 高 CPU 使用率（> 5%）
- 大量内存占用（> 100MB）

**无效服务**：
- 启动后立即停止
- 无实际功能的空服务
- 仅用于保活的服务

## 技术实现

### Hook 机制

拦截 ActivityManagerService 的服务管理方法：
```kotlin
// 服务启动拦截
startServiceLocked(
    IApplicationThread caller,
    Intent service,
    String resolvedType,
    int callingPid,
    int callingUid,
    boolean fgRequired,
    String callingPackage,
    int userId
)

// 服务绑定拦截  
bindServiceLocked(
    IApplicationThread caller,
    IBinder token,
    Intent service,
    String resolvedType,
    IServiceConnection connection,
    int flags,
    String callingPackage,
    int userId
)
```

### 数据跟踪

**实时监控**：
- 服务启动时记录信息
- 跟踪服务运行状态
- 计算资源使用情况

**历史统计**：
- 数据库存储服务历史
- 分析启动模式和趋势
- 生成优化建议

### 兼容性处理

**版本适配**：
- Android 8.0+ 后台服务限制适配
- 不同版本的 API 差异处理
- 前台服务特殊处理

**性能优化**：
- 最小化 Hook 调用开销
- 高效的规则匹配
- 异步处理统计数据

## 相关功能

- [应用管理](app-management.md) - 按应用查看所有服务
- [WakeLock 管理](wakelocks.md) - 服务相关的 WakeLock
- [规则系统](rules-regex.md) - 使用正则表达式批量配置

!!! info "Android 8.0+ 变化"
    Android 8.0 开始限制后台服务，系统会自动停止大部分后台服务。NoWakeLock 的服务管理主要针对前台服务和绑定服务。

!!! warning "谨慎处理"
    拦截关键服务可能导致应用功能异常。建议先使用限制模式，确认无影响后再考虑拦截。