# 常见问题

收集用户最常遇到的问题和解决方案。

## 安装相关

### Q: 模块安装后不工作？
**A**: 检查以下项目：
1. 确认 Xposed 框架正常运行
2. 在框架管理器中勾选 NoWakeLock 模块
3. 重启设备后检查模块状态
4. 确认作用域包含 `android` 系统框架

### Q: 支持哪些 Xposed 框架？
**A**: 支持的框架：
- **LSPosed** - 推荐，兼容性最好
- **EdXposed** - 部分设备支持
- **TaiChi** - 不建议，可能存在兼容问题

### Q: 模块检查显示红色❌？
**A**: 根据具体项目处理：
- **框架未激活** → 检查 Xposed 安装
- **模块未加载** → 确认模块已勾选并重启
- **Hook失败** → 可能是系统版本不兼容

## 功能使用

### Q: 设置规则后没有效果？
**A**: 可能的原因：
1. **规则未生效** - 检查规则是否启用
2. **应用重启** - 部分规则需要应用重新启动
3. **系统缓存** - 等待几分钟让系统应用新规则
4. **权限问题** - 确认 NoWakeLock 有必要权限

### Q: 某个应用无法接收推送？
**A**: 解决步骤：
1. 查看该应用的 WakeLock 列表
2. 找到推送相关的 WakeLock（通常包含 Push、GCM、FCM）
3. 将这些 WakeLock 改为"允许"模式
4. 重启应用测试推送功能

### Q: 应用变得很卡或功能异常？
**A**: 立即处理：
1. 暂时禁用该应用的所有规则
2. 逐个启用规则，找出问题规则
3. 调整问题规则的参数或改为限制模式
4. 避免拦截系统关键服务

### Q: 如何判断优化是否有效？
**A**: 观察指标：
- **短期（24小时）**：查看拦截统计，应用功能正常
- **中期（一周）**：电池续航明显改善
- **长期**：系统整体流畅度提升

## 兼容性问题

### Q: Android 版本兼容性？
**A**: 支持情况：
- **Android 7.0-16** - AOSP 完全支持

### Q: 特定品牌设备问题？
**A**: 已知问题：
- **MIUI** - 需要关闭 MIUI 优化，允许后台运行
- **ColorOS** - 可能需要在权限管理中允许自启动
- **EMUI** - 建议在受保护应用中添加 NoWakeLock
- **OneUI** - ⚠️ **目前尚不支持** - 由于 OneUI 更改了 Android 源码，Hook 位置经过多种方法尝试，始终无法生效

### Q: 系统更新后失效？
**A**: 处理步骤：
1. 检查 Xposed 框架是否仍然工作
2. 确认 NoWakeLock 模块仍在激活状态
3. 必要时重新安装模块
4. 重新配置作用域设置

## 性能问题

### Q: NoWakeLock 本身耗电？
**A**: 正常情况下 NoWakeLock 耗电极少：
- **CPU 使用** < 1%
- **内存占用** < 50MB
- **后台活动** 最小化

如果发现异常耗电，请检查配置或联系支持。

### Q: 设备变慢或卡顿？
**A**: 可能原因：
1. **规则过多** - 减少不必要的规则
2. **复杂正则** - 简化正则表达式
3. **频繁拦截** - 调整拦截策略
4. **内存不足** - 重启设备释放内存

### Q: 应用启动变慢？
**A**: 检查是否：
1. 拦截了应用启动必需的 Service
2. 过度限制了初始化相关的 WakeLock
3. 规则影响了应用的启动流程

## 数据问题

### Q: 统计数据不准确？
**A**: 可能情况：
1. **数据延迟** - 统计每5分钟更新一次
2. **设备重启** - 部分实时数据重启后重置
3. **时区问题** - 检查设备时区设置
4. **存储问题** - 清理数据库缓存

### Q: 历史数据丢失？
**A**: 数据保留策略：
- **实时数据** - 设备重启后清除
- **统计数据** - 保留30天
- **配置数据** - 永久保存（除非手动清除）

### Q: 导出的配置无法导入？
**A**: 检查项目：
1. 文件格式是否正确（JSON）
2. 版本是否兼容
3. 文件是否损坏
4. 权限是否充足

## 多用户问题

### Q: 多用户环境下如何使用？
**A**: 注意事项：
1. 每个用户需要单独配置
2. 系统应用在所有用户间共享设置
3. 切换用户后配置互不影响
4. 某些功能需要主用户权限

### Q: 工作资料下无法使用？
**A**: 工作资料限制：
1. 需要在工作资料中单独安装 Xposed 框架
2. 部分企业策略可能禁止 Xposed 模块
3. 联系管理员确认相关政策

## 安全问题

### Q: NoWakeLock 是否安全？
**A**: 安全措施：
- **开源代码** - 所有代码公开可审查
- **无网络权限** - 不会上传任何数据
- **本地存储** - 所有数据仅保存在设备本地
- **最小权限** - 仅请求必要的系统权限

### Q: 会不会影响系统稳定性？
**A**: 安全性考虑：
1. 使用系统标准的 Hook 机制
2. 对系统调用的影响最小化
3. 异常情况下自动降级处理
4. 不修改系统核心文件

### Q: 隐私数据是否会泄露？
**A**: 隐私保护：
- **无数据收集** - 不收集任何个人信息
- **无网络通信** - 不与外部服务器通信
- **本地处理** - 所有分析在设备本地进行
- **用户控制** - 用户完全控制所有数据

## 故障排除

### Q: 完全无法使用怎么办？
**A**: 重置步骤：
1. 在 Xposed 中禁用模块
2. 重启设备
3. 清除 NoWakeLock 应用数据
4. 重新启用模块并配置

### Q: 某些应用频繁崩溃？
**A**: 紧急处理：
1. 立即禁用该应用的所有规则
2. 检查系统日志中的错误信息
3. 逐步恢复规则并观察
4. 必要时将该应用加入白名单

### Q: 如何收集调试信息？
**A**: 信息收集：
```bash
# 设备信息
adb shell getprop ro.build.version.release
adb shell getprop ro.product.model

# 应用日志
adb logcat | grep -i nowakelock

# Xposed 日志
adb logcat | grep -i xposed
```

## 基础概念

### Q: 什么是 WakeLock/Alarm/Service？如何设置以获得最佳效果？

**A**: 核心概念解释：

**WakeLock（唤醒锁）**：
- 防止设备进入休眠状态的机制
- 类型：PARTIAL（CPU运行）、SCREEN（屏幕常亮）等
- 官方文档：[Android WakeLock 指南](https://developer.android.com/training/scheduling/wakelock)

**Alarm（定时任务）**：
- 系统定时器，在特定时间触发任务
- 类型：RTC、ELAPSED_REALTIME 等
- 官方文档：[Android Alarms 指南](https://developer.android.com/training/scheduling/alarms)

**Service（服务）**：
- 后台运行的应用组件
- 类型：前台服务、后台服务、绑定服务
- 官方文档：[Android Services 指南](https://developer.android.com/guide/components/services)

**推荐学习资源**：
- XDA 指南：["新手 WakeLock 完全指南"](https://forum.xda-developers.com)
- [Amplify](https://forum.xda-developers.com/t/mod-xposed-amplify-battery-extender-control-alarms-services-and-wakelocks.2853874/) - 提供 WakeLock/Alarm/Service 信息参考列表
- [WakeBlock](https://github.com/MrLast98/WakeBlock) - 也提供 WakeLock 信息

**注意**：很遗憾没有完美的通用参考，每个设备之间差异巨大。需要根据具体设备和应用进行调整。

## 严重问题处理

### Q: 错误操作导致设备无法启动怎么办？

**A**: 紧急恢复步骤：

**情况1：NoWakeLock 模块导致的启动问题**：

**方法1：硬件按键安全模式（推荐）**：
```bash
1. 长按电源键10秒强制重启
2. 屏幕变黑后立即反复按任意硬件按键（音量键或电源键）
3. 感受到2次短震动后，继续快速按4次相同按键
4. 第4次按键后感受到长震动，表示 Xposed 已禁用
5. 正常启动后在 LSPosed 中禁用 NoWakeLock 模块
```

**方法2：Recovery 文件系统方法**：
```bash
1. 进入 TWRP Recovery
2. 点击 Advanced → File Manager
3. 导航到 /data/adb/lspd/
4. 删除 config 文件夹
5. 重启到系统
```

**方法3：设备特定方法（如 Pixel）**：
```bash
开机时在 Google Logo 出现后立即疯狂按音量下键
直到设备震动确认进入安全模式
```

**情况2：误拦截重要系统组件**：
```bash
1. 进入 Recovery → 文件管理
2. 导航到 /data/misc/xxx-xxx-xxx/prefs/com.js.nowakelock
   # xxx-xxx-xxx 是一段很长的随机字符串，每个设备可能都不同
3. 删除整个文件夹
4. 重启设备
5. 进入系统后恢复误操作，如果不清楚具体问题，直接清除 NoWakeLock 数据
```

**不确定原因时**：
- 进入系统后直接清除 NoWakeLock 应用数据
- 重新配置，避免拦截系统关键组件

!!! danger "重要警告"
    修改系统关键组件前务必备份配置。建议从第三方应用开始调试，逐步调整系统服务。

## 隐私与安全

### Q: NoWakeLock 是否收集隐私数据？

**A**: 隐私保护承诺：
- **完全本地化** - 所有数据仅存储在设备本地
- **零数据上传** - 不向任何服务器上传数据
- **无隐私收集** - 不收集或存储任何个人信息
- **开源透明** - 源代码完全公开可审查

**未来可能的功能**：
- 可能添加可选的云端配置同步功能
- 用户可完全控制是否启用
- 仍将坚持隐私保护原则

## 参与贡献

### Q: 需要新功能或发现 Bug 怎么办？

**A**: 参与方式：
- **GitHub Issues** - [提交问题或功能请求](https://github.com/NoWakeLock/NoWakeLock/issues)
- **详细描述** - 提供完整的问题描述和重现步骤
- **积极反馈** - 开发者会尽力处理所有反馈

### Q: 如何帮助更新翻译？

**A**: 翻译贡献：
- **Pull Request** - 直接提交翻译 PR
- **多语言支持** - 欢迎各种语言的翻译贡献
- **社区协作** - 可在社区群组讨论翻译细节

## 获取帮助

### Q: 在哪里报告问题？
**A**: 支持渠道：
- **GitHub Issues** - 详细的技术问题和功能请求
- **Telegram群** - [@nowakelock](https://t.me/nowakelock) 快速询问和讨论
- **Discord社区** - [NoWakelock](https://discord.gg/kewmG5AShQ) 深入的技术交流

### Q: 如何提供有效的问题报告？
**A**: 包含信息：
1. **设备信息** - 品牌、型号、Android版本
2. **框架信息** - Xposed框架类型和版本
3. **问题描述** - 具体的问题现象
4. **重现步骤** - 如何重现问题
5. **日志信息** - 相关的错误日志
6. **截图** - 问题界面的截图

### Q: 多久能得到回复？
**A**: 响应时间：
- **社区群组** - 通常几小时内
- **GitHub Issues** - 1-3个工作日
- **紧急问题** - 会优先处理

!!! tip "使用建议"
    遇到问题时，建议先查阅文档和FAQ。如果问题仍然存在，请提供详细信息以便更好地协助解决。

!!! warning "重要提醒"
    使用前请备份重要数据。错误配置可能影响设备正常运行，请谨慎操作。