# 应用管理

应用管理功能允许你按应用查看和配置所有的 WakeLock、Alarm 和 Service，提供应用维度的统一管理视图。

## 功能概述

### 核心功能
- 按应用分类显示所有活动
- 应用级别的统计信息
- 批量配置应用的所有组件
- 应用行为模式分析

### 管理优势
- 统一的应用视角
- 便于识别问题应用
- 简化批量配置流程
- 直观的对比分析

## 界面说明

### 应用列表

【需要截图：应用列表页面】

**显示信息**：
- **应用图标和名称**
- **包名** - 应用唯一标识
- **统计摘要** - WakeLock/Alarm/Service 数量
- **活跃状态** - 最近活动指示器
- **用户** - 多用户环境下的用户标识

### 统计卡片

每个应用显示三类统计：

| 类型 | 指标 | 说明 |
|------|------|------|
| WakeLock | 计数/时长 | 获取次数和累计持有时间 |
| Alarm | 计数/频率 | 触发次数和平均间隔 |
| Service | 计数/时长 | 启动次数和运行时间 |

### 筛选和排序

**筛选选项**：
- 全部应用
- 系统应用
- 用户应用
- 有活动的应用
- 已配置规则的应用

**排序方式**：
- 按应用名称
- 按安装时间
- 按活动频率
- 按资源消耗
- 按配置状态

## 应用详情页面

### 进入详情页
1. 点击应用列表中的任意应用
2. 进入应用详情页面

【需要截图：应用详情页面】

### 详情页内容

#### 应用信息
- 应用名称、版本、包名
- 安装时间、更新时间
- 权限列表
- 当前运行状态

#### 活动统计
- **时间线图表** - 12小时活动趋势
- **分类统计** - WakeLock/Alarm/Service 详细数据
- **资源消耗** - CPU、内存、电量使用

#### 组件列表
按标签页分类显示：
- **WakeLocks** - 该应用的所有 WakeLock
- **Alarms** - 该应用的所有 Alarm
- **Services** - 该应用的所有 Service

## 配置功能

### 应用级配置

#### 全局设置
为应用设置统一规则：
```
允许模式：
- 所有组件正常运行
- 适用于重要应用

限制模式：
- 统一的时间限制
- 适用于一般应用

拦截模式：
- 阻止所有后台活动
- 适用于问题应用
```

#### 继承机制
- 组件级别可继承应用设置
- 支持个别组件的例外配置
- 优先级：组件设置 > 应用设置 > 全局默认

## 多用户支持

### 用户切换
在多用户设备上：
1. 顶部用户选择器
2. 切换查看不同用户的应用
3. 每个用户独立的配置

【需要截图：用户切换界面】

### 用户隔离
- 各用户的配置互不影响
- 系统应用在所有用户间共享
- 用户应用仅在对应用户下显示

## 导入导出

### 配置备份

#### 导出配置
```json
{
  "version": "3.0",
  "timestamp": "2024-01-01T00:00:00Z",
  "user_id": 0,
  "apps": [
    {
      "package_name": "com.example.app",
      "app_config": {
        "mode": "limit",
        "wakelock_timeout": 60000
      },
      "components": [
        {
          "type": "wakelock",
          "name": "ExampleWakeLock",
          "mode": "allow"
        }
      ]
    }
  ]
}
```

#### 导入配置
- 支持完整配置导入
- 选择性导入特定应用
- 冲突处理策略选择

## 相关功能

- [WakeLock 管理](wakelocks.md) - 详细的 WakeLock 控制
- [Alarm 管理](alarms.md) - 详细的 Alarm 控制
- [Service 管理](services.md) - 详细的 Service 控制
- [规则系统](rules-regex.md) - 使用正则表达式批量配置

!!! tip "使用建议"
    应用管理是 NoWakeLock 的入口功能，建议新用户从这里开始了解各应用的行为模式，再进行针对性优化。
