# 数据重构详细总结与实现方案

以下是我们讨论的关键实现细节和最终决定采纳的方案，剔除了讨论过程中未采纳的选项：

## 1. 数据库架构与存储

### 现有数据库结构
- **InfoDatabase**: 存储 wakelock、alarm、service 记录
  - 位置：系统进程中有实时更新的实例，应用进程中有通过 CP 同步的副本
  - 表结构：主要包含 Info 实体，记录各类唤醒事件的统计数据
  
- **AppDatabase**: 存储应用设置与配置
  - 表结构：AppInfo、AppSt、St、Info 等实体
  - 版本：当前为 version 10，有多次自动迁移
  
- **数据流向**：AppDatabase → XSharedPreferences → Xposed hook 读取 → 系统进程 InfoDatabase → ContentProvider → 应用进程 InfoDatabase

### 具体实现决策

1. **数据库实例管理**：
   - 继续使用单例模式管理数据库实例
   - 使用 `getInstance()` 工厂方法确保线程安全
   - 系统进程和应用进程分别维护自己的数据库实例

2. **实体关系设计**：
   - 保留现有实体间的关系
   - 为特定查询场景添加适当的 `@Relation` 注解
   - 使用复合主键（packageName + userId）标识应用

3. **迁移策略**：
   - 使用 Room 的自动迁移功能处理简单架构变更
   - 对于复杂变更，实现自定义 Migration 类
   - 维持数据库版本号递增

## 2. 数据记录优化

Info db 可以不兼容升级

### Wakelock 数据记录改进

1. **时间戳记录**：
   - 需要记录 start 和 end time
   - 还是要记录 count 和 time 已避免应用级别重复计算

### Alarm & Service 数据记录

1. **Alarm 记录字段**：
   - 记录触发时间戳
   - 简单计数还是要记录的

2. **Service 记录改进**：
   - 类似 Alarm 记录启动时间戳
   - 计数还是要存在的

## 3. 应用级统计计算

### 应用 Wakelock 时间计算实现

1. **时间线合并算法**：
   - 算法复杂度：O(n log n)，主要由排序决定
   - 实现步骤：
     1. 收集所有 wakelock 开始和结束事件
     2. 按时间排序所有事件
     3. 线性扫描排序后的事件序列
     4. 跟踪活跃 wakelock 计数，计算非重叠时间段

2. **高效实现细节**：
   - 使用简单事件类型减少内存占用
   - 直接在数据库查询结果上操作，避免对象创建

3. **性能优化策略**：
   - 添加适当索引加速数据库查询
   - 实现简单缓存减少重复计算
   - 使用分段计算处理大数据集

### Block 统计简化方案

1. **避免复杂计算**：
   - 放弃精确计算被阻止的 wakelock 时间
   - 在 UI 中简单展示阻止次数，而非估算的阻止时间
   - 专注于实际唤醒时间的准确计算和展示

2. **实用统计指标**：
   - 统计阻止率（阻止次数/总尝试次数）
   - 对于需要估算的场景，使用全局平均持续时间
   - 在 UI 中明确标示为估计值

## 4. 数据同步机制

### ContentProvider 实现

1. **同步方法设计**：
   - 保留现有的 `ProviderMethod` 枚举定义
   - 扩展方法支持新的数据结构
   - 实现批量操作接口提高效率

2. **数据传输格式**：
   - 使用 Bundle 传输参数和结果
   - 利用 Serializable 序列化复杂对象
   - 对于大量数据，考虑分页传输

3. **同步调用优化**：
   - 使用协程的 IO 调度器处理同步调用
   - 实现错误重试机制
   - 添加超时处理防止阻塞

### 数据一致性保证

1. **事务使用**：
   - 使用 Room 事务包裹批量操作
   - 确保数据库更新原子性
   - 实现简单的乐观锁机制

2. **错误处理策略**：
   - 检测并恢复不一致状态
   - 记录同步错误并提供恢复机制
   - 实现渐进式数据验证

## 5. UI 层实现与性能优化

### 性能优化实现

1. **协程与 Flow 应用**：
   - 使用 `Flow<T>` 传递数据流
   - 利用 `flowOn()` 控制计算线程
   - 使用 `StateFlow` 管理 UI 状态

2. **计算优化**：
   - 使用 `withContext(Dispatchers.IO)` 处理计算
   - 实现简单的内存缓存减少重复计算
   - 使用懒加载模式延迟计算非关键数据

3. **UI 响应性保证**：
   - 添加加载指示器和骨架屏
   - 实现下拉刷新功能
   - 使用分页加载处理大量历史数据

### 设置变更监听

1. **变更通知实现**：
   - 使用 `registerOnSharedPreferenceChangeListener`
   - 注意监听器回调中 key 为 null
   - 监听到变化后调用 `reload()` 刷新数据

2. **设置同步策略**：
   - 尽量减少设置项数量和大小
   - 批量更新减少文件写入次数
   - 使用异步写入避免 UI 阻塞

## 总结

这次数据重构专注于以下具体实现方向：

1. **增强数据记录详细度**：从简单计数改为记录完整时间戳和事件上下文
   
2. **优化核心计算性能**：实现高效的时间线合并算法，处理应用级 wakelock 重叠时间
   
3. **简化复杂功能**：放弃精确计算 block time，专注于实际唤醒统计
   
4. **改进数据同步机制**：优化 ContentProvider 接口，提高跨进程通信效率
   
5. **提升用户体验**：优化 UI 响应性，实现响应式数据流更新

通过这些具体改进，应用将能提供更准确的唤醒统计，同时保持良好的性能和用户体验。整体方案遵循现代 Android 开发最佳实践，充分利用 Kotlin 协程、Flow 和 Room 数据库的优势。

# 方案讨论与实现文档

## 内容提供者（ContentProvider）API 重构

### 问题背景
NoWakeLock 应用的内容提供者（ContentProvider）API 存在冗余和不一致性，导致代码维护困难。多个分散的方法执行相似的功能，需要进行合并和优化。

### 方案选择过程
1. **初始状态分析**：
   - 发现应用中存在多个分散的 API 方法（`UpCount`、`UpBlockCount`、`AddEvent`、`BlockEvent`等）
   - 这些方法功能重叠，增加了维护成本
   - 缺乏清晰的英文文档注释

2. **方案确定**：
   - 采用功能合并式 API 架构
   - 不需要兼容原始不再使用的 CP 方法，可以直接删除
   - 添加规范英文注释遵循最佳实践

### 具体实现

#### 1. 内容提供者方法合并
将原有的多个方法合并为几个功能性方法：
- `RecordEvent`：替代 `UpCount`、`UpBlockCount`、`AddEvent` 和 `BlockEvent`，统一处理事件记录
- `EndEvent`：保留用于记录事件结束
- `LoadInfos` 和 `LoadEvents`：保留用于数据检索
- `ClearData`：合并 `ClearCount` 和 `ClearAll`
- `CheckHookActive`：保留用于状态验证

#### 2. XpRecord 类改进
- 保留了友好的 API 接口（`addEvent`、`blockEvent`、`endEvent`等）
- 这些方法内部调用合并后的 CP 方法
- 使用 Kotlin 的 `apply` 函数简化参数构建

#### 3. Hook 类更新
- 更新了 `WakeLockHook`、`AlarmHook` 和 `ServiceHook` 中的 CP 调用
- 确保所有 Hook 调用正确的新 API 方法

#### 4. 代码质量提升
- 添加了全面的英文文档注释
- 统一了参数处理方式
- 提高了代码的可读性和一致性

## 收益与结果
1. **代码简化**：从多个分散方法减少到几个功能性方法
2. **维护成本降低**：相似功能合并，减少重复逻辑
3. **更好的文档**：清晰的英文注释提高了代码可理解性
4. **一致的接口**：统一的参数处理和返回值
5. **性能优化**：减少了重复功能的代码执行路径