# NoWakeLock 应用 Material Design 3 与 Compose 设计思路文档

## 设计总体思路

NoWakeLock 应用的 Material Design 3 重新设计采用了以下核心原则：

1. **一致性与层次** - 使用一致的组件和视觉层次结构，确保用户可以轻松理解信息架构
2. **功能可发现性** - 通过底部导航和清晰的视觉提示使核心功能易于发现
3. **数据可视化** - 使用图表和进度指示器展示应用统计数据
4. **交互反馈** - 通过状态变化、颜色编码和图标提供清晰的用户操作反馈
5. **空间利用** - 优化屏幕空间利用，确保关键信息优先展示

## 关键设计元素

### 颜色系统
- **主色调**: 蓝色系列作为应用主色调，对应 Material Design 3 的 primary 颜色
- **状态颜色**: 红色表示"已阻止"、绿色表示"已允许"状态
- **表面变体**: 使用不同的表面颜色区分功能区域
- **强调色**: 使用蓝色作为信息/时间相关的强调色

### 排版
- 遵循 Material Design 3 的文本比例和层次结构
- 使用不同文本大小和粗细表示信息重要性
- 采用简洁明了的标签和描述

### 形状
- 圆角卡片和容器增强视觉层次
- 圆形图标容器
- 圆角标签表示状态

## 页面组件结构

### 通用组件

1. **顶部状态栏 (Status Bar)**
   - 对应 Compose: 自定义 StatusBar 组件
   - 显示时间和系统图标

2. **应用栏 (App Bar)**
   - 对应 Compose: TopAppBar
   - 变体: 中心标题、带返回按钮的导航栏、操作按钮

3. **底部导航 (Bottom Navigation)**
   - 对应 Compose: NavigationBar 和 NavigationBarItem
   - 五个主要导航项: 应用、唤醒锁、闹钟、服务、设置
   - 包含图标和标签

4. **内容卡片 (Cards)**
   - 对应 Compose: Card
   - 用于封装相关信息分组

5. **列表项 (List Items)**
   - 对应 Compose: ListItem
   - 包含图标、主要和次要文本、操作区域

6. **过滤芯片 (Filter Chips)**
   - 对应 Compose: FilterChip
   - 用于列表页面的内容过滤

7. **开关 (Switches)**
   - 对应 Compose: Switch
   - 用于开启/关闭功能

8. **统计卡片 (Stats Card)**
   - 对应 Compose: 自定义 Card 与 Row/Column 布局
   - 显示关键数据统计

### 主页/应用列表 (home.html)

主要组件:
- **过滤芯片行** - 用于筛选应用类型 (全部、用户、系统、已修改)
- **排序选项** - 用于按名称、计数或时间排序
- **应用列表项** - 显示应用信息和指标
  - 对应 Compose: LazyColumn 包含自定义 ListItem

设计特点:
- 应用图标使用圆形容器
- 使用标签显示唤醒锁数量和时间
- 右侧箭头指示可点击进入详情

### 应用详情页面 (app_detail.html)

主要组件:
- **应用头部** - 显示应用图标、名称和包名
- **统计摘要** - 显示唤醒锁、闹钟、服务数量和总时间
  - 对应 Compose: 自定义 StatisticsCard
- **标签行** - 在不同内容视图间切换
  - 对应 Compose: TabRow 和 Tab
- **设置卡片** - 包含开关和输入选项
  - 对应 Compose: 自定义 SettingsCard 与 Switch 组件
- **正则表达式阻止模式** - 文本输入区域
  - 对应 Compose: TextField (多行)

设计特点:
- 使用水平标签在不同详情视图间切换
- 开关组件用于快速启用/禁用功能
- 输入框设计简洁，便于输入规则

### 唤醒锁列表页面 (wakelock.html)

主要组件:
- **过滤芯片** - 全部、已阻止、已允许
- **排序选项** - 名称、计数、时间
- **统计摘要卡片** - 显示唤醒锁总数和百分比
  - 对应 Compose: Card 包含 LinearProgressIndicator
- **唤醒锁列表项** - 显示唤醒锁详情
  - 对应 Compose: LazyColumn 包含自定义 ListItem

设计特点:
- 使用进度条可视化阻止/允许比例
- 唤醒锁图标使用紫色主题
- 列表项右侧显示计数

### 唤醒锁详情页面 (wakelock_detail.html)

主要组件:
- **唤醒锁头部** - 显示名称和相关应用
- **统计卡片** - 显示计数、阻止数、总时间、节省时间
- **设置卡片** - 包含阻止开关和时间间隔输入
  - 对应 Compose: Card 包含 Switch 和 TextField
- **活动时间线** - 显示24小时活动图表
  - 对应 Compose: 自定义 Chart 组件
- **最近活动** - 显示活动历史记录
  - 对应 Compose: LazyColumn 包含自定义 ActivityItem

设计特点:
- 使用柱状图展示活动模式
- 左侧边框颜色区分不同活动状态
- 统计数据以卡片布局呈现

### 闹钟列表和闹钟详情页面 (alarm.html, alarm_detail.html)

结构与唤醒锁页面类似，特有组件:
- **闹钟图标** - 使用蓝色时钟图标
- **触发模式信息** - 显示闹钟触发模式
  - 对应 Compose: 自定义 InfoCard

设计特点:
- 闹钟使用蓝色作为主题颜色
- 触发模式信息以背景区分

### 服务列表和服务详情页面 (service.html, service_detail.html)

结构与唤醒锁页面类似，特有组件:
- **服务图标** - 使用绿色齿轮图标
- **服务信息** - 显示服务类型、启动类型和进程
  - 对应 Compose: 自定义 InfoCard

设计特点:
- 服务使用绿色作为主题颜色
- 服务信息以结构化方式呈现

### 设置页面 (settings.html)

主要组件:
- **设置类别标题** - 分隔不同设置组
  - 对应 Compose: Text 带样式
- **设置项** - 包含图标、标题、描述和控件
  - 对应 Compose: 自定义 SettingsItem
- **开关设置项** - 包含开关控件
  - 对应 Compose: SettingsItem 带 Switch
- **输入设置项** - 包含数字输入字段
  - 对应 Compose: SettingsItem 带 TextField
- **导航设置项** - 包含右箭头
  - 对应 Compose: SettingsItem 带点击处理

设计特点:
- 类别标题使用紫色区分
- 每个设置项包含图标增强识别度
- 输入字段仅在需要时显示

## Material Design 3 特定组件

1. **Material 3 Cards**
   - 更新的圆角设计
   - 更精细的阴影和高度系统
   - 表面处理更加柔和

2. **Navigation Bar (底部导航)**
   - 更宽敞的点击区域
   - 加入图标和文本标签
   - 激活状态清晰

3. **Chips (过滤芯片)**
   - 更新的圆角外观
   - 更清晰的选中状态
   - 改进的触摸反馈

4. **Switches (开关)**
   - 更新的轨道/滑块设计
   - 更大的触摸目标
   - 清晰的开/关状态指示

5. **Progress Indicators (进度指示器)**
   - 用于统计信息可视化
   - 以品牌色彩显示百分比

6. **Tabs (标签)**
   - 简化的标签设计
   - 下划线指示激活状态
   - 适应不同宽度

## 交互设计模式

1. **过滤与排序**
   - 顶部芯片用于快速过滤
   - 排序选项影响列表顺序

2. **列表到详情**
   - 列表项点击进入详情页
   - 返回按钮回到列表

3. **设置开关**
   - 直接切换功能开关
   - 即时视觉反馈

4. **标签页导航**
   - 水平滑动切换内容页
   - 标签指示当前页面

5. **底部导航**
   - 主要导航结构
   - 图标和文本指示当前位置

这些设计思路和组件结构将在使用Jetpack Compose实现时，提供清晰的指导方向，确保应用遵循Material Design 3的设计语言，同时保持功能的可用性和一致性。
