package com.js.nowakelock.ui.theme

import androidx.compose.ui.graphics.Color

// 主要色调 - 使用更有活力的蓝色，符合Google品牌色
val Primary80 = Color(0xFF1A73E8) // 暗色模式主色
val Primary40 = Color(0xFF1A73E8) // 亮色模式主色 - 使用更鲜明的蓝色

// 次要色调 - 更鲜明的配色
val Secondary80 = Color(0xFF7BABF7) // 暗色模式次要色
val Secondary40 = Color(0xFF4285F4) // 亮色模式次要色 - 调整为更鲜明的蓝色

// 第三色调 - 更有活力的绿松石色
val Tertiary80 = Color(0xFF36CFC9) // 暗色模式第三色
val Tertiary40 = Color(0xFF26A69A) // 亮色模式第三色 - 更深、更有活力的色调

// 强调色 - 提供点缀
val AccentLight = Color(0xFFF25D50) // 珊瑚红强调色
val AccentLight2 = Color(0xFFFFBB00) // 黄色强调色

// 背景和表面 - 稍微调整以提升层次感
val Background = Color(0xFFF8F9FA) // 浅灰背景
val Surface = Color(0xFFFFFFFF)    // 白色表面
val SurfaceVariant = Color(0xFFE8EAED) // 浅灰表面变体
val SurfaceContainer = Color(0xFFF1F3F4) // 容器表面，增加微妙变化

// 状态颜色 - 使用Google官方颜色，更有活力
val AllowedGreen = Color(0xFF34A853) // 允许状态绿色
val BlockedRed = Color(0xFFEA4335)   // 阻止状态红色
val WarningYellow = Color(0xFFFBBC05) // 警告状态黄色

// 文字颜色
val OnSurface = Color(0xFF202124)    // 主要文字颜色
val OnSurfaceVariant = Color(0xFF5F6368) // 次要文字颜色