/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.achartengine.model.XYSeries;

public class MultipleCategorySeries
implements Serializable {
    private String mTitle;
    private List<String> mCategories = new ArrayList<String>();
    private List<String[]> mTitles = new ArrayList<String[]>();
    private List<double[]> mValues = new ArrayList<double[]>();

    public MultipleCategorySeries(String string) {
        this.mTitle = string;
    }

    public void add(String[] stringArray, double[] dArray) {
        this.add(this.mCategories.size() + "", stringArray, dArray);
    }

    public void add(String string, String[] stringArray, double[] dArray) {
        this.mCategories.add(string);
        this.mTitles.add(stringArray);
        this.mValues.add(dArray);
    }

    public void remove(int n) {
        this.mCategories.remove(n);
        this.mTitles.remove(n);
        this.mValues.remove(n);
    }

    public void clear() {
        this.mCategories.clear();
        this.mTitles.clear();
        this.mValues.clear();
    }

    public double[] getValues(int n) {
        return this.mValues.get(n);
    }

    public String getCategory(int n) {
        return this.mCategories.get(n);
    }

    public int getCategoriesCount() {
        return this.mCategories.size();
    }

    public int getItemCount(int n) {
        return this.mValues.get(n).length;
    }

    public String[] getTitles(int n) {
        return this.mTitles.get(n);
    }

    public XYSeries toXYSeries() {
        XYSeries xYSeries = new XYSeries(this.mTitle);
        return xYSeries;
    }
}

