/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYValueSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class BubbleChart
extends XYChart {
    public static final String TYPE = "Bubble";
    private static final int SHAPE_WIDTH = 10;
    private static final int MIN_BUBBLE_SIZE = 2;
    private static final int MAX_BUBBLE_SIZE = 20;

    BubbleChart() {
    }

    public BubbleChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        paint.setColor(xYSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        int n2 = fArray.length;
        XYValueSeries xYValueSeries = (XYValueSeries)this.mDataset.getSeriesAt(n);
        double d = xYValueSeries.getMaxValue();
        double d2 = 20.0 / d;
        for (int i = 0; i < n2; i += 2) {
            double d3 = xYValueSeries.getValue(i / 2) * d2 + 2.0;
            this.drawCircle(canvas, paint, fArray[i], fArray[i + 1], (float)d3);
        }
    }

    @Override
    protected RectF[] clickableAreasForPoints(float[] fArray, float f, int n) {
        int n2 = fArray.length;
        XYValueSeries xYValueSeries = (XYValueSeries)this.mDataset.getSeriesAt(n);
        double d = xYValueSeries.getMaxValue();
        double d2 = 20.0 / d;
        RectF[] rectFArray = new RectF[n2 / 2];
        for (int i = 0; i < n2; i += 2) {
            double d3 = xYValueSeries.getValue(i / 2) * d2 + 2.0;
            rectFArray[i / 2] = new RectF(fArray[i] - (float)d3, fArray[i + 1] - (float)d3, fArray[i] + (float)d3, fArray[i + 1] + (float)d3);
        }
        return rectFArray;
    }

    @Override
    public int getLegendShapeWidth(int n) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, int n, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        this.drawCircle(canvas, paint, f + 10.0f, f2, 3.0f);
    }

    private void drawCircle(Canvas canvas, Paint paint, float f, float f2, float f3) {
        canvas.drawCircle(f, f2, f3, paint);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

