<div align="center">

![GitHub tag (latest SemVer)](https://img.shields.io/github/tag/LemmyNet/jerboa.svg)
[![status-badge](https://woodpecker.join-lemmy.org/api/badges/LemmyNet/jerboa/status.svg)](https://woodpecker.join-lemmy.org/LemmyNet/jerboa)
[![GitHub issues](https://img.shields.io/github/issues-raw/LemmyNet/jerboa.svg)](https://github.com/LemmyNet/jerboa/issues)
[![License](https://img.shields.io/github/license/LemmyNet/jerboa.svg)](LICENSE)
[![Translation status](https://weblate.join-lemmy.org/widget/lemmy/jerboa/svg-badge.svg)](https://weblate.join-lemmy.org/projects/lemmy/jerboa/)
![GitHub stars](https://img.shields.io/github/stars/LemmyNet/jerboa?style=social)

</div>

<p align="center">
  <a href="https://github.com/LemmyNet/jerboa" rel="noopener">
  <img width=200px height=200px src="https://raw.githubusercontent.com/LemmyNet/jerboa/main/app/src/main/res/jerboa.svg"></a>

  <h3 align="center"><a href="https://github.com/LemmyNet/jerboa">Jerboa</a></h3>
  <p align="center">
    An Android client for <a href="https://github.com/LemmyNet/lemmy">Lemmy</a>, a federated reddit alternative
    <br />
    <br />
    <a href="https://join-lemmy.org">Join Lemmy</a>
    ·
    <a href="https://github.com/LemmyNet/jerboa/issues">Report Bug</a>
    ·
    <a href="https://github.com/LemmyNet/jerboa/issues">Request Feature</a>
    ·
    <a href="https://github.com/LemmyNet/jerboa/blob/main/RELEASES.md">Releases</a>
  </p>
  <p align="center">
    <a href="https://apt.izzysoft.de/fdroid/index/apk/com.jerboa"><img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid" height="80"></a>
    <a href="https://f-droid.org/packages/com.jerboa"><img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80"></a>
    <a href="https://play.google.com/store/apps/details?id=com.jerboa"><img src="https://cdn.rawgit.com/steverichey/google-play-badge-svg/master/img/en_get.svg" height="80"></a>
    <a href="https://github.com/LemmyNet/jerboa/releases/latest"><img src="https://raw.githubusercontent.com/andOTP/andOTP/master/assets/badges/get-it-on-github.png" height="80"></a>
  </p>
</p>

## About Jerboa

| Homepage                                                                   | Post & Comments                                                          |
| -------------------------------------------------------------------------- | ------------------------------------------------------------------------ |
| ![img_1](./fastlane/metadata/android/en-US/images/phoneScreenshots/01.png) | ![img_2](fastlane/metadata/android/en-US/images/phoneScreenshots/02.png) |

Jerboa is an Android client for Lemmy, built using the native Android toolkit and Jetpack Compose.

**Note**: You can submit issues, but between Lemmy and lemmy-ui, the developers probably won't have too much time to work on them. You can learn Jetpack Compose and contribute if you want to help make this app better.

### Built With

- [Android Jetpack Compose](https://developer.android.com/jetpack/compose)
- [Kotlin](https://kotlinlang.org/)
- [Retrofit](https://square.github.io/retrofit/)

## Features

- Open-source, [AGPL License](/LICENSE).

## Installation / Releases

- [Releases](https://github.com/LemmyNet/jerboa/releases)
- [IzzyOnDroid](https://apt.izzysoft.de/fdroid/index/apk/com.jerboa)
- [F-Droid](https://f-droid.org/en/packages/com.jerboa/)
- [Google Play](https://play.google.com/store/apps/details?id=com.jerboa)

## Support / Donate

Jerboa is made by Lemmy's developers, and is free, open-source software, meaning no advertising, monetizing, or venture capital, ever. Your donations directly support full-time development of the project.

Jerboa and Lemmy are made possible by a generous grant from the [NLnet foundation](https://nlnet.nl/).

- [Support on Liberapay](https://liberapay.com/Lemmy).
- [Support on Ko-fi](https://ko-fi.com/lemmynet).
- [Support on OpenCollective](https://opencollective.com/lemmy).
- [Support on Patreon](https://www.patreon.com/dessalines).

### Crypto

- bitcoin: `1Hefs7miXS5ff5Ck5xvmjKjXf5242KzRtK`
- ethereum: `0x400c96c96acbC6E7B3B43B1dc1BB446540a88A01`
- monero: `41taVyY6e1xApqKyMVDRVxJ76sPkfZhALLTjRvVKpaAh2pBd4wv9RgYj1tSPrx8wc6iE1uWUfjtQdTmTy2FGMeChGVKPQuV`

## Contact

- [Mastodon](https://mastodon.social/@LemmyDev)
- [Jerboa dev chat](https://matrix.to/#/#jerboa-dev:matrix.org)
- [Lemmy chat](https://matrix.to/#/#lemmy:matrix.org)

## Credits

Icons made by [Freepik](https://www.freepik.com) from [www.flaticon.com](https://www.flaticon.com).
