/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Smoke Reducer derivative work created by J05HYYY 2012
 */

package com.java.SmokeReducer;

// Need the following import to get access to the app resources, since this
// class is in a sub-package.
import com.java.SmokeReducer.R;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

import android.app.AlarmManager;
import android.app.PendingIntent;
import java.util.Calendar;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;

import android.widget.TextView;
import java.util.Date;

//Just for testing
import android.widget.Toast;

/**
 * <p>Example of explicitly starting and stopping the {@link ForegroundService}.
 */

public class SmokeReducer extends Activity {

public static final String BROADCAST_ACTION = "com.java.SmokeReducer.displayevent";

	PendingIntent sender = null;
	AlarmManager am;
	PendingIntent senderTwo = null;
	AlarmManager amTwo;

    public void createAlarm(long nextTime){
//Toast.makeText(SmokeReducer.this, "Well, I got this far!", Toast.LENGTH_LONG).show();
	 Long average;
	 if ( nextTime > -1 ) average = nextTime; else average = (long)MyGlobals.getAverage();

	if ( average > 0 ) {

		TextView t = new TextView(this);
		t=(TextView)findViewById(R.id.time_label); 
    		t.setText("Next time is at: " + new Date(System.currentTimeMillis() + average).toLocaleString());

		View b = findViewById(R.id.smoke);
		b.setVisibility(View.GONE);
		b = findViewById(R.id.no_thanks);
		b.setVisibility(View.GONE);
		MyGlobals.setButtonStateOne();

	 // get a Calendar object with current time
	 //Calendar cal = Calendar.getInstance();
	 //cal.setTimeInMillis(System.currentTimeMillis());
	 //cal.add(Calendar.MILLISECOND,previous);

	 Intent alarmIntent = new Intent(SmokeReducer.this, AlarmReceiver.class);
	 // In reality, you would want to have a static variable for the request code instead of 192837
	 sender = PendingIntent.getBroadcast(SmokeReducer.this, 0, alarmIntent, 0);
	 // Get the AlarmManager service
	 am = (AlarmManager) getSystemService(ALARM_SERVICE);
	 //am.set(AlarmManager.RTC_WAKEUP, cal.getTimeInMillis() + average, sender);
	 am.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + average, sender);

	 Intent alarmIntentTwo = new Intent(BROADCAST_ACTION);
	 // In reality, you would want to have a static variable for the request code instead of 192837
	 senderTwo = PendingIntent.getBroadcast(SmokeReducer.this, 0, alarmIntentTwo, 0);
	 // Get the AlarmManager service
	 amTwo = (AlarmManager) getSystemService(ALARM_SERVICE);
	 //am.set(AlarmManager.RTC_WAKEUP, cal.getTimeInMillis() + average, senderTwo);
	 amTwo.set(AlarmManager.RTC_WAKEUP, System.currentTimeMillis() + average, senderTwo);

		MyGlobals.setPublicNextTime(System.currentTimeMillis() + average);
	}
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        super.onCreate(savedInstanceState);

        setContentView(R.layout.smoke_reducer);

	// Start foreground process
        Intent intent = new Intent(ForegroundService.ACTION_FOREGROUND);
        intent.setClass(SmokeReducer.this, ForegroundService.class);
        startService(intent);

        // Watch for button clicks.

	Button button;
        button = (Button)findViewById(R.id.smoke);
        button.setOnClickListener(mSmokeListener);
        button = (Button)findViewById(R.id.no_thanks);
        button.setOnClickListener(mNoThanksListener);
        button = (Button)findViewById(R.id.sleep);
        button.setOnClickListener(mSleepListener);

// Check, for when starting the application whether the alarm should instantly play, or take a while to play.

		if (MyGlobals.getMPlayerState() == 0)
		{
			MyGlobals.init(this);

			if ( sender != null ) am.cancel(sender);
			if ( senderTwo != null ) amTwo.cancel(senderTwo);

			MyGlobals.readTime();
			long nextTime = MyGlobals.isItTime();

			if ( nextTime == 0 ){
				//Toast.makeText(SmokeReducer.this, "The time is now!", Toast.LENGTH_LONG).show();
				//The time is now!
				MyGlobals.hasSlept();
				MyGlobals.loop();
			}
			else if ( nextTime > 0)
			{
				//Toast.makeText(SmokeReducer.this, "Time =" + nextTime, Toast.LENGTH_LONG).show();
				//The time is later, so set alarm
				createAlarm(nextTime);
			}

			//MyGlobals.hasSlept();
		}

/*
			Integer buttonState = MyGlobals.getButtonState();
			if (buttonState == 1){

        			View b = findViewById(R.id.smoke);
				b.setVisibility(View.GONE);
				b = findViewById(R.id.no_thanks);
				b.setVisibility(View.GONE);
			}
			else if (buttonState == 2){
        			View b = findViewById(R.id.smoke);
				b.setVisibility(View.VISIBLE);
				b = findViewById(R.id.no_thanks);
				b.setVisibility(View.GONE);
			}
			else if (buttonState == 3){
        			View b = findViewById(R.id.smoke);
				b.setVisibility(View.VISIBLE);
				b = findViewById(R.id.no_thanks);
				b.setVisibility(View.VISIBLE);
			}
*/
    }

    private OnClickListener mSmokeListener = new OnClickListener() {
        public void onClick(View v) {
		boolean isPlayerOnOrOff = MyGlobals.startOrStop(); //start or stop smoking sound playing
		 if (isPlayerOnOrOff == false)
			{
				createAlarm(-1);
				int seconds = (int) (MyGlobals.getAverage() / 1000) % 60 ;
				int minutes = (int) ((MyGlobals.getAverage() / (1000*60)) % 60);
				int hours   = (int) ((MyGlobals.getAverage() / (1000*60*60)) % 24);
				Toast.makeText(SmokeReducer.this, "Time between smokes is now: " + hours + " hrs, " + minutes + " mins, " + seconds + " secs.", Toast.LENGTH_LONG).show();
			}
	}
    };


    private OnClickListener mNoThanksListener = new OnClickListener() {
        public void onClick(View v) {
		MyGlobals.stop();
		View b = findViewById(R.id.smoke);
		b.setVisibility(View.VISIBLE);
		b = findViewById(R.id.no_thanks);
		b.setVisibility(View.GONE);
		MyGlobals.setButtonStateTwo();
        }
    };

    private OnClickListener mSleepListener = new OnClickListener() {
        public void onClick(View v) {
            stopService(new Intent(SmokeReducer.this,
                    ForegroundService.class));
	    if ( sender != null ) am.cancel(sender);
	    if ( senderTwo != null ) amTwo.cancel(senderTwo);
	    MyGlobals.free();
	    finish();
        }
    };

/////////////////////////////////////////////


    private BroadcastReceiver broadcastReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
        	View b = findViewById(R.id.smoke);
		b.setVisibility(View.VISIBLE);
		b = findViewById(R.id.no_thanks);
		b.setVisibility(View.VISIBLE);
        }
    };    
    
	@Override
	public void onResume() {
		super.onResume();
		registerReceiver(broadcastReceiver,new IntentFilter(BROADCAST_ACTION));

		if (MyGlobals.getMPlayerState() == 0) MyGlobals.init(this);

		MyGlobals.readTime();
		Integer buttonState = MyGlobals.getButtonState();
			if (buttonState == 1){

        			View b = findViewById(R.id.smoke);
				b.setVisibility(View.GONE);
				b = findViewById(R.id.no_thanks);
				b.setVisibility(View.GONE);
			}
			else if (buttonState == 2){
        			View b = findViewById(R.id.smoke);
				b.setVisibility(View.VISIBLE);
				b = findViewById(R.id.no_thanks);
				b.setVisibility(View.GONE);
			}
			else if (buttonState == 3){
        			View b = findViewById(R.id.smoke);
				b.setVisibility(View.VISIBLE);
				b = findViewById(R.id.no_thanks);
				b.setVisibility(View.VISIBLE);
			}

		if (MyGlobals.getPublicNextTime() > -1){
			TextView t = new TextView(this);
			t=(TextView)findViewById(R.id.time_label); 
    			t.setText("Next time is at: " + new Date(MyGlobals.getPublicNextTime()).toLocaleString());
		}
	}

	@Override
	public void onPause() {
		super.onPause();
		unregisterReceiver(broadcastReceiver);
	}

	//@Override
	//public void onStart() {
	//	super.onStart();
	//}
}

