/*
 * Decompiled with CFR 0.152.
 */
package de.keyboardsurfer.android.widget.crouton;

import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;

final class DefaultAnimationsBuilder {
    private static final long DURATION = 400L;
    private static Animation slideInDownAnimation;
    private static Animation slideOutUpAnimation;
    private static int lastInAnimationHeight;
    private static int lastOutAnimationHeight;

    private DefaultAnimationsBuilder() {
    }

    static Animation buildDefaultSlideInDownAnimation(View croutonView) {
        if (!DefaultAnimationsBuilder.areLastMeasuredInAnimationHeightAndCurrentEqual(croutonView) || null == slideInDownAnimation) {
            slideInDownAnimation = new TranslateAnimation(0.0f, 0.0f, (float)(-croutonView.getMeasuredHeight()), 0.0f);
            slideInDownAnimation.setDuration(400L);
            DefaultAnimationsBuilder.setLastInAnimationHeight(croutonView.getMeasuredHeight());
        }
        return slideInDownAnimation;
    }

    static Animation buildDefaultSlideOutUpAnimation(View croutonView) {
        if (!DefaultAnimationsBuilder.areLastMeasuredOutAnimationHeightAndCurrentEqual(croutonView) || null == slideOutUpAnimation) {
            slideOutUpAnimation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-croutonView.getMeasuredHeight()));
            slideOutUpAnimation.setDuration(400L);
            DefaultAnimationsBuilder.setLastOutAnimationHeight(croutonView.getMeasuredHeight());
        }
        return slideOutUpAnimation;
    }

    private static boolean areLastMeasuredInAnimationHeightAndCurrentEqual(View croutonView) {
        return DefaultAnimationsBuilder.areLastMeasuredAnimationHeightAndCurrentEqual(lastInAnimationHeight, croutonView);
    }

    private static boolean areLastMeasuredOutAnimationHeightAndCurrentEqual(View croutonView) {
        return DefaultAnimationsBuilder.areLastMeasuredAnimationHeightAndCurrentEqual(lastOutAnimationHeight, croutonView);
    }

    private static boolean areLastMeasuredAnimationHeightAndCurrentEqual(int lastHeight, View croutonView) {
        return lastHeight == croutonView.getMeasuredHeight();
    }

    private static void setLastInAnimationHeight(int lastInAnimationHeight) {
        DefaultAnimationsBuilder.lastInAnimationHeight = lastInAnimationHeight;
    }

    private static void setLastOutAnimationHeight(int lastOutAnimationHeight) {
        DefaultAnimationsBuilder.lastOutAnimationHeight = lastOutAnimationHeight;
    }
}

