# TAGLINE

Hidden web parameter discovery tool

# TLDR

**Find hidden parameters**

```x8 -u [https://example.com/page] -w [params.txt]```

**With custom headers**

```x8 -u [url] -w [wordlist] -H "[Cookie: value]"```

**Output to file**

```x8 -u [url] -w [wordlist] -o [output.txt]```

**Multiple URLs**

```x8 -l [urls.txt] -w [params.txt]```

# SYNOPSIS

**x8** [_-u url_] [_-w wordlist_] [_-H header_] [_options_]

# PARAMETERS

**-u** _URL_
> Target URL.

**-l** _FILE_
> URL list.

**-w** _FILE_
> Parameter wordlist.

**-H** _HEADER_
> Custom header.

**-o** _FILE_
> Output file.

# DESCRIPTION

**x8** is a hidden parameter discovery tool for web applications used in authorized security testing and bug bounty research. It sends requests with candidate parameter names from a wordlist and analyzes responses to identify parameters that the application accepts but does not publicly document.

The tool supports discovery through multiple HTTP methods including GET query parameters, POST body data, and HTTP headers. Concurrent request handling enables fast scanning, and multiple URLs can be processed from a file for batch testing.

# CAVEATS

Authorized use only. May be detected. Rust implementation.

# HISTORY

**x8** was created for hidden parameter discovery in web applications during security testing.

# SEE ALSO

[arjun](/man/arjun)(1), [paramspider](/man/paramspider)(1), [ffuf](/man/ffuf)(1)
