# TAGLINE

Terminal typing speed test

# TLDR

**Start typing test**

```wpm```

**Practice with text file**

```wpm [text.txt]```

**Set duration**

```wpm -d [60]```

**Set word count**

```wpm -w [50]```

# SYNOPSIS

**wpm** [_-d seconds_] [_-w count_] [_options_] [_file_]

# PARAMETERS

**-d** _SEC_
> Duration.

**-w** _COUNT_
> Word count.

**--help**
> Show help.

# DESCRIPTION

**wpm** is a terminal-based typing speed test that measures words per minute and accuracy. It presents text passages for the user to type, tracking speed and error rate in a distraction-free terminal environment.

Custom text files can be provided for practice with specific content, and test duration or word count can be configured. The tool is useful for practicing touch typing and benchmarking typing performance over time.

# CAVEATS

Terminal only. Various implementations. Practice tool.

# HISTORY

**wpm** (words per minute) tools measure typing speed in the terminal for practice and benchmarking.

# SEE ALSO

[toipe](/man/toipe)(1), [tt](/man/tt)(1), [typespeed](/man/typespeed)(1)
