# TAGLINE

Disassemble WebAssembly binary to text

# TLDR

**Convert to WAT**

```wasm2wat [input.wasm]```

**Output to file**

```wasm2wat [input.wasm] -o [output.wat]```

**Fold expressions**

```wasm2wat --fold-exprs [input.wasm]```

**Generate names**

```wasm2wat --generate-names [input.wasm]```

# SYNOPSIS

**wasm2wat** [_-o output_] [_--fold-exprs_] [_options_] _input_

# PARAMETERS

**-o** _FILE_
> Output file.

**--fold-exprs**
> Fold expressions.

**--generate-names**
> Generate names.

**--inline-exports**
> Inline exports.

**--help**
> Show help.

# DESCRIPTION

**wasm2wat** is a disassembler from the WABT (WebAssembly Binary Toolkit) that converts WebAssembly binary (.wasm) files into the human-readable WebAssembly Text Format (WAT). The WAT output uses S-expression syntax that represents the module structure, functions, types, imports, and exports in a readable form.

The tool is essential for debugging and inspecting compiled WebAssembly modules, allowing developers to examine the actual instructions generated by compilers. Options like --fold-exprs produce more compact output by nesting expressions, and --generate-names assigns readable names to unnamed functions and variables.

Output can be written to a file or printed to stdout for piping to other tools. The reverse operation (text to binary) is performed by the companion tool wat2wasm.

# CAVEATS

One-way mostly. Part of WABT. Large output for big modules.

# HISTORY

**wasm2wat** is part of **WABT** (WebAssembly Binary Toolkit), converting binary WASM to readable WAT text format.

# SEE ALSO

[wat2wasm](/man/wat2wasm)(1), [wasm2c](/man/wasm2c)(1), [wasm-objdump](/man/wasm-objdump)(1)
