# TAGLINE

Customizable Chromium-based web browser

# TLDR

**Start browser**

```vivaldi```

**Open URL**

```vivaldi [https://example.com]```

**New window**

```vivaldi --new-window [url]```

**Incognito mode**

```vivaldi --incognito```

**With profile**

```vivaldi --profile-directory="[Profile 1]"```

# SYNOPSIS

**vivaldi** [_--new-window_] [_--incognito_] [_options_] [_url_]

# PARAMETERS

**--new-window**
> New window.

**--incognito**
> Private browsing.

**--profile-directory** _DIR_
> Use profile.

**--app** _URL_
> App mode.

**--help**
> Show help.

# DESCRIPTION

**vivaldi** is a feature-rich, Chromium-based web browser designed for power users who want extensive control over their browsing experience. It supports modern web standards through its Chromium engine while adding a highly customizable user interface on top.

The browser includes advanced tab management features such as tab stacking, tab tiling for side-by-side viewing, and a tab bar that can be placed on any edge of the window. Built-in productivity tools include a notes panel, email client, calendar, feed reader, and translation service, reducing the need for separate applications or extensions.

Nearly every aspect of the interface can be customized, from keyboard shortcuts and mouse gestures to toolbar layouts and color themes. The browser also supports command chaining, custom search engines, and a web panel sidebar for keeping frequently used sites accessible.

# CAVEATS

Proprietary parts. Chromium base. Resource usage.

# HISTORY

**Vivaldi** was created by **Jon von Tetzchner**, co-founder of Opera, for power users wanting customization.

# SEE ALSO

[firefox](/man/firefox)(1), [chromium](/man/chromium)(1), [google-chrome](/man/google-chrome)(1)
