# TAGLINE

Decompress XZ compressed files

# TLDR

**Decompress file**

```unxz [file.xz]```

**Keep original**

```unxz -k [file.xz]```

**To stdout**

```unxz -c [file.xz]```

**Force overwrite**

```unxz -f [file.xz]```

**Decompress multiple**

```unxz [file1.xz] [file2.xz]```

# SYNOPSIS

**unxz** [_-k_] [_-c_] [_-f_] [_options_] _files_

# PARAMETERS

**-k**
> Keep original.

**-c**
> Write to stdout.

**-f**
> Force overwrite.

**-v**
> Verbose mode.

**-q**
> Quiet mode.

# DESCRIPTION

**unxz** decompresses files that were compressed with the XZ format, which uses the LZMA2 algorithm for high compression ratios. It is functionally equivalent to running **xz --decompress** and is provided as a convenience command within the xz-utils package.

By default, unxz replaces the compressed .xz file with the decompressed output, removing the original. The **-k** flag preserves the original compressed file, and **-c** writes decompressed data to standard output for piping to other commands.

XZ is widely used in the Linux ecosystem for distributing source code tarballs, kernel sources, and package archives due to its excellent compression ratio. While decompression is fast, XZ compression is slower and more memory-intensive than alternatives like gzip or zstd.

# CAVEATS

Slow for very large files. Part of xz-utils. Single-threaded by default.

# HISTORY

**unxz** is part of **xz-utils**, equivalent to running xz with decompression mode.

# SEE ALSO

[xz](/man/xz)(1), [gzip](/man/gzip)(1), [bzip2](/man/bzip2)(1)
