# TAGLINE

High-precision scientific calculator

# TLDR

**Launch calculator**

```speedcrunch```

**Open session file**

```speedcrunch [session.sch]```

# SYNOPSIS

**speedcrunch** [_options_] [_file_]

# PARAMETERS

_file_
> Session file to open.

**--help**
> Show help.

**--version**
> Show version.

# DESCRIPTION

**SpeedCrunch** is a high-precision desktop scientific calculator designed for keyboard-driven operation. It evaluates mathematical expressions typed into an input line, supporting variables, custom functions, and a comprehensive built-in function library covering trigonometry, statistics, and more.

The interface features syntax highlighting for expressions, auto-completion for function names, and a scrollable history of previous calculations. Results are computed with arbitrary precision, and the application supports unit conversions between common measurement systems.

Sessions can be saved and restored from files, preserving calculation history and defined variables. SpeedCrunch is cross-platform, built with Qt, and available for Linux, Windows, and macOS.

# FEATURES

- Keyboard-driven
- Auto-completion
- Unit conversions
- Custom functions
- Session saving

# CAVEATS

GUI application. Qt required. Desktop environment needed.

# HISTORY

**SpeedCrunch** was created as a fast, high-precision scientific calculator with a focus on keyboard-driven operation.

# SEE ALSO

[bc](/man/bc)(1), [calc](/man/calc)(1), [qalc](/man/qalc)(1)
