# TAGLINE

View Ruby API documentation

# TLDR

**View class documentation**

```ri [Array]```

**View method documentation**

```ri [Array#map]```

**View instance method**

```ri [String#split]```

**View class method**

```ri [File.open]```

**List all classes**

```ri -l```

# SYNOPSIS

**ri** [_options_] [_name_...]

# PARAMETERS

**-l**, **--list**
> List classes.

**-f**, **--format** _name_
> Output format.

**-i**, **--interactive**
> Interactive mode.

**-T**, **--no-pager**
> Don't use pager.

**--doc-dir** _dir_
> Documentation directory.

# DESCRIPTION

**ri** (Ruby Information) displays Ruby documentation from the command line. It reads documentation generated by RDoc and provides quick access to class and method information.

# EXAMPLES

```bash
# Class documentation
ri Array
ri String

# Instance method (use #)
ri Array#each
ri String#gsub

# Class method (use .)
ri File.read
ri Dir.glob

# Search for method
ri -l | grep map

# Interactive mode
ri -i
```

# NOTATION

```
Class          - ri Array
Class#method   - Instance method (ri Array#map)
Class.method   - Class method (ri File.open)
Class::Const   - Constant (ri File::SEPARATOR)
```

# CAVEATS

Documentation must be installed. Use gem rdoc --all to generate gem docs. Part of Ruby standard library.

# HISTORY

ri is part of **Ruby's** RDoc system, providing command-line documentation access since early Ruby versions.

# SEE ALSO

[rdoc](/man/rdoc)(1), [ruby](/man/ruby)(1), [irb](/man/irb)(1)
