# TAGLINE

Python package installer and manager

# TLDR

**Install a package**

```pip install [package]```

**Install a specific version**

```pip install [package]==[1.0.0]```

**Install packages from requirements file**

```pip install -r [requirements.txt]```

**Upgrade a package**

```pip install --upgrade [package]```

**Uninstall a package**

```pip uninstall [package]```

**List installed packages**

```pip list```

**Show package information**

```pip show [package]```

**Generate requirements file**

```pip freeze > [requirements.txt]```

**Install for current user only**

```pip install --user [package]```

# SYNOPSIS

**pip** _command_ [_options_] [_package_...]

**pip** install [_options_] _package_

**python -m pip** _command_ [_options_]

# COMMANDS

**install**
> Install packages

**uninstall**
> Remove packages

**list**
> List installed packages

**show**
> Show package information

**freeze**
> Output installed packages in requirements format

**search**
> Search PyPI for packages (deprecated)

**download**
> Download packages without installing

**wheel**
> Build wheel packages

**check**
> Verify installed packages have compatible dependencies

**config**
> Manage configuration

**cache**
> Manage pip's cache

# PARAMETERS

**-U**, **--upgrade**
> Upgrade packages to newest version

**--user**
> Install to user directory (~/.local)

**-r**, **--requirement** _FILE_
> Install from requirements file

**--no-deps**
> Don't install dependencies

**--force-reinstall**
> Reinstall even if up-to-date

**-I**, **--ignore-installed**
> Ignore installed packages

**--pre**
> Include pre-release versions

**-i**, **--index-url** _URL_
> Base URL of package index

**--extra-index-url** _URL_
> Additional package index URL

**-e**, **--editable** _PATH_
> Install in editable/development mode

**--target** _DIR_
> Install to specified directory

**-y**, **--yes**
> Don't ask for confirmation

**-q**, **--quiet**
> Minimal output

**-v**, **--verbose**
> Verbose output

**-V**, **--version**
> Show version

**-h**, **--help**
> Show help

# DESCRIPTION

**pip** is the package installer for Python, used to install and manage packages from the Python Package Index (PyPI) and other repositories. It handles dependency resolution, downloading, and installation of Python packages.

Packages can be installed globally (requires root), per-user with **--user**, or in virtual environments (recommended). Version specifiers allow precise control: **==** for exact, **>=** for minimum, **~=** for compatible versions.

The **requirements.txt** format, generated by **pip freeze**, records exact versions for reproducible installations. Modern Python recommends using **python -m pip** instead of the bare **pip** command to ensure the correct Python interpreter is used.

# CONFIGURATION

**~/.config/pip/pip.conf** (Linux), **~/Library/Application Support/pip/pip.conf** (macOS), **%APPDATA%\pip\pip.ini** (Windows)
> User-level configuration file for default options.

**/etc/pip.conf** (Linux/macOS), **C:\ProgramData\pip\pip.ini** (Windows)
> Global system-wide configuration file.

**$VIRTUAL_ENV/pip.conf**
> Site-level configuration within a virtual environment.

**PIP_INDEX_URL**
> Environment variable to set the default package index URL.

**PIP_EXTRA_INDEX_URL**
> Environment variable for additional package index URLs.

**PIP_CONFIG_FILE**
> Environment variable to override the config file location.

**PIP_NO_CACHE_DIR**
> Environment variable to disable the pip cache.

# CAVEATS

On Linux systems, avoid using pip with sudo to install packages globally as it can conflict with system packages. Use virtual environments or **--user** instead. Some distributions rename pip to **pip3** for Python 3. The search command was disabled on PyPI due to abuse. Package installation may require compilation and build dependencies.

# HISTORY

pip was created by **Ian Bicking** and first released in **2008** as a replacement for easy_install. The name is a recursive acronym: "**p**ip **i**nstalls **p**ackages". It became the standard Python package manager, included by default with Python since version 3.4. The Python Packaging Authority (PyPA) now maintains pip, continuously improving dependency resolution, security, and performance.

# SEE ALSO

[python](/man/python)(1), [virtualenv](/man/virtualenv)(1), [pipenv](/man/pipenv)(1), [conda](/man/conda)(1)
