# TAGLINE

automatically generated by npm to lock dependency versions

# TLDR

**Generate/update lock file**

```npm install```

**Clean install from lock file**

```npm ci```

**Update specific package**

```npm update [package]```

**View lock file diff**

```git diff package-lock.json```

# SYNOPSIS

**package-lock.json** - npm dependency lock file

# DESCRIPTION

**package-lock.json** is automatically generated by npm to lock dependency versions. It records the exact version of every installed package and its dependencies, ensuring reproducible builds.

The file should be committed to version control to ensure consistent installs across environments.

# KEY FIELDS

```json
{
  "name": "my-project",
  "lockfileVersion": 3,
  "packages": {
    "": { "dependencies": {...} },
    "node_modules/lodash": {
      "version": "4.17.21",
      "resolved": "https://registry.npmjs.org/...",
      "integrity": "sha512-..."
    }
  }
}
```

# LOCK FILE VERSIONS

```
v1 - npm 5-6
v2 - npm 7+ (backwards compatible)
v3 - npm 7+ (optimized)
```

# CAVEATS

Don't edit manually. Commit to git. Use npm ci for CI builds. Conflicts common in merges.

# HISTORY

package-lock.json was introduced in **npm 5** (2017) to address reproducibility issues, replacing npm-shrinkwrap.json for most use cases.

# SEE ALSO

[npm](/man/npm)(1), [npm-ci](/man/npm-ci)(1), [yarn.lock](/man/yarn.lock)(5)
