# TAGLINE

GNU Octave, a numerical computing language

# TLDR

**Start interactive session**

```octave```

**Run script**

```octave [script.m]```

**Execute expression**

```octave --eval "[expression]"```

**Run without GUI**

```octave --no-gui```

**Silent mode**

```octave --quiet [script.m]```

# SYNOPSIS

**octave** [_options_] [_file_]

# PARAMETERS

_FILE_
> Script file to execute.

**--eval** _EXPR_
> Evaluate expression.

**--no-gui**
> Run without GUI.

**--quiet**, **-q**
> Suppress startup messages.

**--interactive**, **-i**
> Force interactive mode.

**--help**
> Display help information.

# DESCRIPTION

**octave** is GNU Octave, a numerical computing language. MATLAB compatible.

The tool provides matrix operations and plotting. Scientific computing environment.

# CAVEATS

MATLAB compatibility varies. Large memory for big matrices. GUI optional.

# HISTORY

GNU Octave was created by **John W. Eaton** as a free MATLAB alternative.

# SEE ALSO

[matlab](/man/matlab)(1), [gnuplot](/man/gnuplot)(1), [python](/man/python)(1)

