# TAGLINE

creates Angular artifacts using schematics

# TLDR

**Generate component**

```ng generate component [name]```

**Generate service**

```ng generate service [name]```

**Generate module**

```ng generate module [name]```

**Generate with shorthand**

```ng g c [name]```

**Generate in specific path**

```ng generate component [path/name]```

**Dry run**

```ng generate component [name] --dry-run```

# SYNOPSIS

**ng** **generate** _schematic_ _name_ [_options_]

# PARAMETERS

**component**
> Generate a component.

**service**
> Generate a service.

**module**
> Generate a module.

**directive**
> Generate a directive.

**pipe**
> Generate a pipe.

**--dry-run**
> Preview without writing.

**--skip-tests**
> Skip test file generation.

# DESCRIPTION

**ng generate** creates Angular artifacts using schematics. Generates components, services, modules, and other building blocks. Supports shorthand g for generate. Part of Angular CLI.

# SEE ALSO

[ng](/man/ng)(1), [ng-add](/man/ng-add)(1)

