# TAGLINE

next

# TLDR

**Create Next.js app**

```next create [app-name]```

**Start development server**

```next dev```

**Build for production**

```next build```

**Start production server**

```next start```

**Export static site**

```next export```

**Run linter**

```next lint```

**Show info**

```next info```

# SYNOPSIS

**next** [_command_] [_options_]

# PARAMETERS

_COMMAND_
> Next.js command.

**dev**
> Start development server.

**build**
> Build application.

**start**
> Start production server.

**export**
> Export to static HTML.

**lint**
> Run ESLint.

**--help**
> Display help information.

# DESCRIPTION

**next** is the Next.js CLI. It develops and builds React applications.

The tool provides server-side rendering. Supports static generation and API routes.

# CAVEATS

Node.js required. React-based. Configuration in next.config.js.

# HISTORY

Next.js was created by **Vercel** in 2016 as a React framework for production applications.

# SEE ALSO

[npm](/man/npm)(1), [vercel](/man/vercel)(1), [node](/man/node)(1)

