# TAGLINE

classic roguelike dungeon exploration game

# TLDR

**Start new game**

```nethack```

**Start with specific role**

```nethack -p [Wizard]```

**Start with specific race**

```nethack -r [Elf]```

**Restore saved game**

```nethack -u [playername]```

**Show version**

```nethack --version```

# SYNOPSIS

**nethack** [_options_]

# DESCRIPTION

**nethack** is a classic roguelike dungeon exploration game. Players descend through procedurally generated dungeons to retrieve the Amulet of Yendor, facing monsters, traps, and challenges.

The game features permadeath, ASCII graphics, and an incredibly deep gameplay system with countless interactions between items, monsters, and the environment.

# PARAMETERS

**-p** _role_
> Character role/class.

**-r** _race_
> Character race.

**-u** _name_
> Player name.

**-s**
> Show high scores.

**-n**
> Start with no stripes (simpler display).

**-D**
> Debug/wizard mode.

# ROLES

Archeologist, Barbarian, Caveman, Healer, Knight, Monk, Priest, Ranger, Rogue, Samurai, Tourist, Valkyrie, Wizard

# KEY COMMANDS

**hjkl/arrows**: Move
**o**: Open door
**c**: Close door
**s**: Search
**e**: Eat
**q**: Quaff
**r**: Read
**w**: Wield
**W**: Wear
**T**: Take off
**,**: Pick up
**d**: Drop

# CAVEATS

Steep learning curve. Permadeath means careful play needed. ASCII interface takes adjustment. Very deep mechanics to learn.

# HISTORY

**NetHack** evolved from **Hack** (1985), itself derived from **Rogue** (1980). The NetHack DevTeam has maintained it since **1987**, making it one of the longest-developed games. Its open development model pioneered collaborative game development.

# SEE ALSO

[rogue](/man/rogue)(6), [angband](/man/angband)(6), [crawl](/man/crawl)(6), [frotz](/man/frotz)(1)
