# TAGLINE

elixir build tool

# TLDR

**Create new project**

```mix new [project_name]```

**Install dependencies**

```mix deps.get```

**Compile project**

```mix compile```

**Run tests**

```mix test```

**Start interactive shell**

```iex -S mix```

**Run task**

```mix [task_name]```

# SYNOPSIS

**mix** _task_ [_options_]

# PARAMETERS

_TASK_
> Mix task to run.

**new** _NAME_
> Create new project.

**deps.get**
> Fetch dependencies.

**compile**
> Compile project.

**test**
> Run tests.

**format**
> Format code.

**--help**
> Display help information.

# DESCRIPTION

**mix** is the Elixir build tool. It manages projects, dependencies, and tasks.

The tool creates projects, compiles code, and runs tests. Central to Elixir development.

# CAVEATS

Requires Elixir. Hex for packages. Task-based system.

# HISTORY

Mix was created as the build tool for **Elixir**, providing project management and task automation.

# SEE ALSO

[elixir](/man/elixir)(1), [iex](/man/iex)(1), [hex](/man/hex)(1)

