# TAGLINE

open-source voxel game engine and sandbox game similar to Minecraft

# TLDR

**Start Minetest client**

```minetest```

**Connect to server**

```minetest --address [server.example.com] --port [30000]```

**Start with specific game**

```minetest --gameid [minetest_game]```

**Run in terminal mode**

```minetest --terminal```

# SYNOPSIS

**minetest** [_options_]

# PARAMETERS

**--address** _host_
> Server address to connect to.

**--port** _port_
> Server port (default 30000).

**--name** _name_
> Player name.

**--password** _pass_
> Player password.

**--gameid** _id_
> Game ID to use.

**--world** _path_
> World directory.

**--config** _file_
> Configuration file.

**--terminal**
> Run in terminal mode.

**--info**
> Print info and exit.

# DESCRIPTION

**minetest** is an open-source voxel game engine and sandbox game similar to Minecraft. Supports multiplayer, modding, and custom content. Highly extensible through Lua scripting.

# SEE ALSO

[minetestserver](/man/minetestserver)(1)

