# TAGLINE

macro processor

# TLDR

**Process file**

```m4 [input.m4]```

**Output to file**

```m4 [input.m4] > [output.txt]```

**Define macro**

```m4 -D [NAME=value] [input.m4]```

**Include directory**

```m4 -I [/path/to/includes] [input.m4]```

**Prefix builtins**

```m4 -P [input.m4]```

**Debug output**

```m4 -d [input.m4]```

# SYNOPSIS

**m4** [_options_] [_files_]

# PARAMETERS

_FILES_
> Input files to process.

**-D** _NAME=VALUE_
> Define macro.

**-U** _NAME_
> Undefine macro.

**-I** _DIR_
> Add include path.

**-P**
> Prefix builtins with m4_.

**-d**
> Enable debug output.

**--help**
> Display help information.

# DESCRIPTION

**m4** is a macro processor. It expands macros in text files to generate output.

The tool is used to preprocess configuration files and source code. It's part of autoconf.

# CAVEATS

POSIX standard. Quoting rules can be tricky. Used by autoconf extensively.

# HISTORY

m4 was developed at **Bell Labs** in the 1970s. The GNU version extends the original POSIX specification.

# SEE ALSO

[autoconf](/man/autoconf)(1), [cpp](/man/cpp)(1), [make](/man/make)(1)

