# TAGLINE

installer CLI for creating new Laravel PHP framework applications

# TLDR

**Create new Laravel project**

```laravel new [project-name]```

**Create project with specific starter kit**

```laravel new [project-name] --jet```

**Create project with Breeze**

```laravel new [project-name] --breeze```

**Create without Git initialization**

```laravel new [project-name] --no-git```

# SYNOPSIS

**laravel** _command_ [_options_]

# PARAMETERS

**new** _name_
> Create a new Laravel application.

**--jet**
> Install with Laravel Jetstream.

**--breeze**
> Install with Laravel Breeze.

**--pest**
> Use Pest for testing.

**--no-git**
> Skip Git initialization.

**--force**
> Overwrite existing directory.

# DESCRIPTION

**laravel** is the Laravel installer CLI for creating new Laravel PHP framework applications. Provides scaffolding options for starter kits like Jetstream and Breeze. Alternative to using Composer create-project.

# SEE ALSO

[composer](/man/composer)(1), [php-artisan](/man/php-artisan)(1)

