# TAGLINE

professional digital painting application

# TLDR

**Open Krita**

```krita```

**Open file**

```krita [image.kra]```

**Open multiple files**

```krita [file1.png] [file2.kra]```

**Export from command line**

```krita --export --export-filename [output.png] [input.kra]```

**Start with no splash**

```krita --nosplash```

# SYNOPSIS

**krita** [_options_] [_files_...]

# PARAMETERS

_FILES_
> Image files to open.

**--export**
> Export mode.

**--export-filename** _FILE_
> Export output file.

**--nosplash**
> Disable splash screen.

**--new-image** _SPEC_
> Create new image.

**--help**
> Display help information.

# DESCRIPTION

**Krita** is a professional digital painting application. It supports brushes, layers, filters, and animation.

The tool targets concept artists, illustrators, and texture artists. It has extensive brush customization.

# CAVEATS

Resource intensive. Large brush packs. KDE-based.

# HISTORY

Krita began as part of **KOffice** in 1999 and evolved into a leading open-source digital painting application.

# SEE ALSO

[gimp](/man/gimp)(1), [inkscape](/man/inkscape)(1), [blender](/man/blender)(1)
