# TAGLINE

modern load testing tool

# TLDR

**Run load test**

```k6 run [script.js]```

**Run with virtual users**

```k6 run --vus [10] --duration [30s] [script.js]```

**Run with iterations**

```k6 run --iterations [100] [script.js]```

**Cloud execution**

```k6 cloud [script.js]```

**Output to JSON**

```k6 run --out json=[results.json] [script.js]```

**Pause threshold**

```k6 run --throw-on-abort [script.js]```

# SYNOPSIS

**k6** _command_ [_options_] _script_

# PARAMETERS

**run** _SCRIPT_
> Run load test script.

**cloud** _SCRIPT_
> Run on k6 Cloud.

**--vus** _N_
> Virtual users.

**--duration** _TIME_
> Test duration.

**--iterations** _N_
> Total iterations.

**--out** _OUTPUT_
> Output destination.

**--help**
> Display help information.

# DESCRIPTION

**k6** is a modern load testing tool. It uses JavaScript for test scripts with a powerful API.

The tool produces detailed performance metrics. It supports cloud execution and CI/CD integration.

# CAVEATS

JavaScript ES6 subset. Not Node.js runtime. Cloud features need account.

# HISTORY

k6 was created by **Load Impact** (now Grafana Labs) as a developer-centric load testing tool.

# SEE ALSO

[jmeter](/man/jmeter)(1), [ab](/man/ab)(1), [wrk](/man/wrk)(1), [hey](/man/hey)(1)
