# TAGLINE

waveform viewer for digital simulation results

# TLDR

**Open waveform file**

```gtkwave [dump.vcd]```

**Open with save file**

```gtkwave [dump.vcd] [signals.gtkw]```

**Convert FST to VCD**

```vcd2fst [input.vcd] [output.fst]```

**Open LXT file**

```gtkwave [dump.lxt]```

# SYNOPSIS

**gtkwave** [_options_] [_dumpfile_] [_savefile_]

# PARAMETERS

_dumpfile_
> Waveform file (VCD, FST, LXT, LXT2).

_savefile_
> GTKWave save file (.gtkw).

**-o**, **--optimize**
> Optimize VCD loading.

**-c** _file_
> Script file to execute.

**-r** _file_
> Read RC file.

**-S** _script_
> Tcl script.

**-T**
> Use Tcl as scripting language.

# DESCRIPTION

**GTKWave** is a waveform viewer for digital simulation results. It displays signal traces from VCD (Value Change Dump), FST, LXT, and other formats generated by simulators like Verilator, Icarus Verilog, and GHDL.

The tool provides hierarchical signal browsing, zoom/pan, markers, annotations, and export capabilities for analyzing digital circuit behavior.

# SUPPORTED FORMATS

- VCD (IEEE 1364)
- FST (Fast Signal Trace)
- LXT, LXT2 (compressed formats)
- GHW (GHDL waveform)
- VZT (compressed VCD)

# CAVEATS

Large VCD files may be slow; use FST format. Complex hierarchies need navigation. Memory usage scales with dump size.

# HISTORY

GTKWave was written by **Tony Bybell** as an open-source waveform viewer for digital design verification. It has become the standard viewer for open-source HDL simulators.

# SEE ALSO

[iverilog](/man/iverilog)(1), [verilator](/man/verilator)(1), [ghdl](/man/ghdl)(1)
