# TAGLINE

Create pull request from command line

# TLDR

**Create pull request**

```git pull-request```

**Create with title**

```git pull-request -m "[title]"```

**Create to specific branch**

```git pull-request -b [base_branch]```

# SYNOPSIS

**git** **pull-request** [_options_]

# PARAMETERS

**-m**, **--message** _text_
> PR title/message.

**-b**, **--base** _branch_
> Base branch.

**-h**, **--head** _branch_
> Head branch.

# DESCRIPTION

**git pull-request** creates a GitHub pull request from the command line. Part of git-extras or hub, it pushes the current branch if needed and opens a pull request to the specified base branch.

The command can extract PR title and body from commit messages or prompt for them interactively. Modern alternatives include the official `gh` CLI tool which provides more comprehensive GitHub integration.

# SEE ALSO

[gh-pr-create](/man/gh-pr-create)(1), [git-extras](/man/git-extras)(1)
