# TAGLINE

Collection of useful Git utilities and commands

# TLDR

**Install git-extras**

```git extras --version```

**Update git-extras**

```git extras update```

**List available commands**

```git extras --help```

# SYNOPSIS

**git** **extras** [_options_]

# PARAMETERS

**--version**
> Show version.

**--help**
> Show available commands.

**update**
> Update git-extras.

# DESCRIPTION

**git extras** is a comprehensive collection of Git utility commands that extend Git's functionality beyond its core feature set. The package includes dozens of helper commands designed to streamline common Git workflows and provide shortcuts for repetitive tasks.

Notable commands include git-summary for repository statistics, git-changelog for generating change logs, git-effort for tracking development activity, git-delete-branch for safe branch cleanup, git-ignore for template-based .gitignore creation, and git-undo for reverting recent changes.

Installation methods vary by platform, with packages available through Homebrew, apt, yum, and manual installation from source. The tools are implemented primarily as shell scripts, making them portable and easy to customize.

# SEE ALSO

[git](/man/git)(1), [git-summary](/man/git-summary)(1)
