# TAGLINE

modern declarative diagram scripting language

# TLDR

**Compile a D2 diagram** to SVG

```d2 [diagram.d2] [output.svg]```

**Compile to PNG** format

```d2 --format png [diagram.d2] [output.png]```

**Watch for changes** and auto-recompile

```d2 --watch [diagram.d2] [output.svg]```

**Use a specific layout** engine

```d2 --layout [elk] [diagram.d2] [output.svg]```

**Apply a theme**

```d2 --theme [200] [diagram.d2] [output.svg]```

**Format/pretty-print** a D2 file

```d2 fmt [diagram.d2]```

# SYNOPSIS

**d2** [_options_] _input.d2_ [_output_]

# PARAMETERS

_INPUT_
> D2 source file to compile.

_OUTPUT_
> Output file path (format inferred from extension).

**--format** _FORMAT_
> Output format: svg, png, pdf.

**--layout** _ENGINE_
> Layout engine: dagre (default), elk, tala.

**--theme** _ID_
> Theme ID (0-200+).

**--watch**, **-w**
> Watch input file and recompile on changes.

**--sketch**
> Render in hand-drawn sketch style.

**--pad** _N_
> Padding around diagram in pixels.

**fmt**
> Format/reindent D2 source file.

**--help**
> Display help information.

# DESCRIPTION

**D2** is a modern diagram scripting language that turns text into diagrams. It uses a declarative syntax to describe nodes, connections, and layouts, producing professional-looking diagrams without manual positioning.

D2 supports various diagram types including flowcharts, entity-relationship diagrams, sequence diagrams, and class diagrams. The language is designed to be readable and version-control friendly, with automatic layout handling.

The tool offers multiple layout engines with different strengths. Watch mode enables live preview during editing. Themes provide consistent styling, and the sketch mode creates a hand-drawn aesthetic.

# CAVEATS

Complex diagrams may require layout hints for optimal appearance. Some features require the TALA layout engine (proprietary). Large diagrams can be slow to render. PNG output requires additional dependencies.

# HISTORY

D2 was created by Terrastruct and released as open source in **2022**. It was designed as a modern alternative to older diagram tools like Graphviz, with better defaults, more features, and improved aesthetics out of the box.

# SEE ALSO

[dot](/man/dot)(1), [mermaid](/man/mermaid)(1), [plantuml](/man/plantuml)(1)
