# TAGLINE

manage Cradle framework packages

# TLDR

**Create a package**

```cradle package create [package_name]```

**List packages**

```cradle package list```

**Update a package**

```cradle package update [package_name]```

# SYNOPSIS

**cradle** **package** _command_ [_options_]

# DESCRIPTION

**cradle package** manages packages in the Cradle PHP framework. It handles package creation, listing, and updates for Cradle modules and extensions.

This command provides package development and maintenance capabilities. Creating packages generates the necessary directory structure and configuration files for new modules. Listing shows all installed packages with version information. Updating packages fetches the latest versions while respecting dependency constraints.

Cradle packages are modular components that can be shared across applications or published for community use. The package system enables code reuse and separation of concerns in Cradle applications.

# SEE ALSO

[cradle](/man/cradle)(1), [cradle-install](/man/cradle-install)(1)
