# TAGLINE

Remove build artifacts from a Rust project

# TLDR

**Remove entire target directory**

```cargo clean```

**Remove release artifacts only**

```cargo clean --release```

**Remove documentation only**

```cargo clean --doc```

**Clean specific package**

```cargo clean -p [package]```

**Preview without deleting**

```cargo clean --dry-run```

**Clean specific profile**

```cargo clean --profile [dev]```

**Clean for specific target**

```cargo clean --target [x86_64-unknown-linux-gnu]```

# SYNOPSIS

**cargo clean** [_options_]

# DESCRIPTION

**cargo clean** removes build artifacts generated by Cargo from the target directory. With no options, deletes the entire target directory.

# PARAMETERS

**--release**
> Remove artifacts in release directory

**--profile** _name_
> Remove artifacts for specified profile

**--doc**
> Remove only documentation directory

**-p**, **--package** _spec_
> Clean only specified packages

**--target** _triple_
> Clean for specified target architecture

**--target-dir** _dir_
> Custom target directory path

**--dry-run**
> Show what would be deleted without deleting

**-v**, **--verbose**
> Display actual files to be deleted (with --dry-run)

# ENVIRONMENT

**CARGO_TARGET_DIR**
> Override target directory location

# CAVEATS

Without package selection, cleans all packages and dependencies in workspace. The target directory can grow very large; regular cleaning frees significant disk space.

# SEE ALSO

[cargo](/man/cargo)(1), [cargo-build](/man/cargo-build)(1)
